/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.imobiliario;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.Eixo;
import br.com.elotech.tributos.domain.LogradouroTestada;
import br.com.elotech.tributos.domain.Zoneamento;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.envers.Audited;

@Entity
@Table(name="TRIBIMOBILIARIOTESTADA")
@Audited
public class CadastroImobiliarioTestada
implements EloEntity<Long> {
    @Id
    @Column(name="idkey")
    @EloSequence(applyOnMerge=true, sequenceName="S_TRIBIMOBILIARIOTESTADA_ID")
    private Long id;
    @ManyToOne
    @JoinColumn(name="idlogradourotestada", referencedColumnName="idlogradourotestada")
    private LogradouroTestada logradouroTestada;
    private BigDecimal tamanhoTestada = BigDecimal.ZERO;
    private BigDecimal tamanhoAdicional = BigDecimal.ZERO;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Principal")
    private Boolean principal = Boolean.FALSE;
    @Column(length=10)
    @Caption(value="N\u00famero")
    private String numero;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="utilizaParaCalculo")
    private Boolean utilizaParaCalculo = Boolean.TRUE;
    @ManyToOne
    @JoinColumn(name="ideixo", referencedColumnName="ideixo")
    private Eixo eixo;
    @ManyToOne
    @JoinColumn(name="idzoneamento", referencedColumnName="idzoneamento")
    private Zoneamento zoneamento;
    private Long guiasRebaixadas;
    private BigDecimal tamanhoGuiaRebaixada = BigDecimal.ZERO;

    public BigDecimal getTamanhoTestada() {
        return this.tamanhoTestada;
    }

    public BigDecimal getTamanhoAdicional() {
        return this.tamanhoAdicional;
    }

    public Boolean getPrincipal() {
        return this.principal;
    }

    public String getNumero() {
        return this.numero;
    }

    public Boolean getUtilizaParaCalculo() {
        return this.utilizaParaCalculo;
    }

    public Eixo getEixo() {
        return this.eixo;
    }

    public Zoneamento getZoneamento() {
        return this.zoneamento;
    }

    public Long getGuiasRebaixadas() {
        return this.guiasRebaixadas;
    }

    public BigDecimal getTamanhoGuiaRebaixada() {
        return this.tamanhoGuiaRebaixada;
    }

    public void setTamanhoTestada(BigDecimal tamanhoTestada) {
        this.tamanhoTestada = tamanhoTestada;
    }

    public void setTamanhoAdicional(BigDecimal tamanhoAdicional) {
        this.tamanhoAdicional = tamanhoAdicional;
    }

    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public void setUtilizaParaCalculo(Boolean utilizaParaCalculo) {
        this.utilizaParaCalculo = utilizaParaCalculo;
    }

    public void setEixo(Eixo eixo) {
        this.eixo = eixo;
    }

    public void setZoneamento(Zoneamento zoneamento) {
        this.zoneamento = zoneamento;
    }

    public void setGuiasRebaixadas(Long guiasRebaixadas) {
        this.guiasRebaixadas = guiasRebaixadas;
    }

    public void setTamanhoGuiaRebaixada(BigDecimal tamanhoGuiaRebaixada) {
        this.tamanhoGuiaRebaixada = tamanhoGuiaRebaixada;
    }

    public Long getId() {
        return this.id;
    }

    public LogradouroTestada getLogradouroTestada() {
        return this.logradouroTestada;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setLogradouroTestada(LogradouroTestada logradouroTestada) {
        this.logradouroTestada = logradouroTestada;
    }

    public String toString() {
        return "CadastroImobiliarioTestada(id=" + this.getId() + ", logradouroTestada=" + this.getLogradouroTestada() + ", tamanhoTestada=" + this.getTamanhoTestada() + ", tamanhoAdicional=" + this.getTamanhoAdicional() + ", principal=" + this.getPrincipal() + ", numero=" + this.getNumero() + ", utilizaParaCalculo=" + this.getUtilizaParaCalculo() + ", eixo=" + this.getEixo() + ", zoneamento=" + this.getZoneamento() + ", guiasRebaixadas=" + this.getGuiasRebaixadas() + ", tamanhoGuiaRebaixada=" + this.getTamanhoGuiaRebaixada() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroImobiliarioTestada)) {
            return false;
        }
        CadastroImobiliarioTestada other = (CadastroImobiliarioTestada)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CadastroImobiliarioTestada;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

