/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.tributos.domain.ProprietarioItbiId;
import br.com.elotech.tributos.domain.TipoProprietarioItbi;
import br.com.elotech.tributos.dto.ProprietarioItbiDTO;
import java.math.BigDecimal;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="TRIBPROPRIETARIOITBI")
public class ProprietarioItbi {
    @EmbeddedId
    private ProprietarioItbiId id;
    private Long vinculo;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean principal = Boolean.FALSE;
    private BigDecimal percentual = BigDecimal.ZERO;
    private BigDecimal percentualVenda = BigDecimal.ZERO;

    public static ProprietarioItbi from(ProprietarioItbiDTO dto) {
        ProprietarioItbi proprietarioItbi = new ProprietarioItbi();
        proprietarioItbi.setVinculo(dto.getVinculo());
        proprietarioItbi.setPrincipal(dto.getPrincipal());
        proprietarioItbi.setPercentual(dto.getPercentual());
        proprietarioItbi.setPercentualVenda(dto.getPercentualVenda());
        return proprietarioItbi;
    }

    public Boolean isAtual() {
        return TipoProprietarioItbi.ATUAL.equals((Object)this.id.getTipoProprietarioItbi());
    }

    public ProprietarioItbiId getId() {
        return this.id;
    }

    public Long getVinculo() {
        return this.vinculo;
    }

    public Boolean getPrincipal() {
        return this.principal;
    }

    public BigDecimal getPercentual() {
        return this.percentual;
    }

    public BigDecimal getPercentualVenda() {
        return this.percentualVenda;
    }

    public void setId(ProprietarioItbiId id) {
        this.id = id;
    }

    public void setVinculo(Long vinculo) {
        this.vinculo = vinculo;
    }

    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    public void setPercentual(BigDecimal percentual) {
        this.percentual = percentual;
    }

    public void setPercentualVenda(BigDecimal percentualVenda) {
        this.percentualVenda = percentualVenda;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProprietarioItbi)) {
            return false;
        }
        ProprietarioItbi other = (ProprietarioItbi)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ProprietarioItbiId this$id = this.getId();
        ProprietarioItbiId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProprietarioItbi;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProprietarioItbiId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public String toString() {
        return "ProprietarioItbi(id=" + this.getId() + ", vinculo=" + this.getVinculo() + ", principal=" + this.getPrincipal() + ", percentual=" + this.getPercentual() + ", percentualVenda=" + this.getPercentualVenda() + ")";
    }
}

