/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.converter.TipoModeloCampoConverter;
import br.com.elotech.tributos.domain.ModeloResposta;
import br.com.elotech.tributos.domain.TipoModeloCampo;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.Audited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TRIBMODELOCAMPO")
@Audited
public class ModeloCampo
implements EloEntity<Long> {
    @Id
    @Column(name="idkey")
    @EloSequence(applyOnMerge=true, sequenceName="S_TRIBMODELOCAMPO_ID")
    private Long id;
    @NotNull
    private Long modeloCampo;
    @NotEmpty
    @Length(max=50)
    @Caption(value="Descri\u00e7\u00e3o")
    private @NotEmpty @Length(max=50) String descricao;
    @Column(name="tipocampo")
    @Convert(converter=TipoModeloCampoConverter.class)
    private TipoModeloCampo tipoModeloCampo;
    @Caption(value="Tamanho")
    private Long tamanho;
    @Length(max=50)
    @Caption(value="M\u00e1scara")
    private @Length(max=50) String mascara;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Multi Resposta")
    private Boolean multiResposta = Boolean.FALSE;
    @Caption(value="Sequencia BCI")
    private Long sequenciaBCI;
    @Caption(value="Descri\u00e7\u00e3o Abreviada")
    @Length(max=50)
    private @Length(max=50) String descricaoAbreviada;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBMODELOCAMPO_IDKEY", updatable=false, nullable=false)
    @AuditJoinTable(name="TRIBMODELORESPOSTA_CAMPO_AUD")
    @Caption(value="Modelo Resposta")
    private final List<ModeloResposta> modeloRespostas = new ArrayList();

    public Long getId() {
        return this.id;
    }

    public Long getModeloCampo() {
        return this.modeloCampo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public TipoModeloCampo getTipoModeloCampo() {
        return this.tipoModeloCampo;
    }

    public Long getTamanho() {
        return this.tamanho;
    }

    public String getMascara() {
        return this.mascara;
    }

    public Boolean getMultiResposta() {
        return this.multiResposta;
    }

    public Long getSequenciaBCI() {
        return this.sequenciaBCI;
    }

    public String getDescricaoAbreviada() {
        return this.descricaoAbreviada;
    }

    public List<ModeloResposta> getModeloRespostas() {
        return this.modeloRespostas;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setModeloCampo(Long modeloCampo) {
        this.modeloCampo = modeloCampo;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public void setTipoModeloCampo(TipoModeloCampo tipoModeloCampo) {
        this.tipoModeloCampo = tipoModeloCampo;
    }

    public void setTamanho(Long tamanho) {
        this.tamanho = tamanho;
    }

    public void setMascara(String mascara) {
        this.mascara = mascara;
    }

    public void setMultiResposta(Boolean multiResposta) {
        this.multiResposta = multiResposta;
    }

    public void setSequenciaBCI(Long sequenciaBCI) {
        this.sequenciaBCI = sequenciaBCI;
    }

    public void setDescricaoAbreviada(String descricaoAbreviada) {
        this.descricaoAbreviada = descricaoAbreviada;
    }

    public String toString() {
        return "ModeloCampo(id=" + this.getId() + ", modeloCampo=" + this.getModeloCampo() + ", descricao=" + this.getDescricao() + ", tipoModeloCampo=" + this.getTipoModeloCampo() + ", tamanho=" + this.getTamanho() + ", mascara=" + this.getMascara() + ", multiResposta=" + this.getMultiResposta() + ", sequenciaBCI=" + this.getSequenciaBCI() + ", descricaoAbreviada=" + this.getDescricaoAbreviada() + ", modeloRespostas=" + this.getModeloRespostas() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModeloCampo)) {
            return false;
        }
        ModeloCampo other = (ModeloCampo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModeloCampo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

