/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.TipoLogradouro;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

@Entity(name="logradouro")
public class Logradouro
implements EloEntity<Long> {
    @Id
    @Column(name="idkey")
    @EloSequence(sequenceName="S_LOGRADOURO_ID")
    private Long id;
    @ManyToOne
    @Caption(value="Cidade")
    @NotNull
    private Cidade cidade;
    private Long logradouro;
    @ManyToOne
    @JoinColumn(name="tipologradouro")
    private TipoLogradouro tipoLogradouro;
    @Length(max=100)
    @Caption(value="Descri\u00e7\u00e3o")
    private @Length(max=100) String descricao;
    @Caption(value="Correto")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean correto = Boolean.FALSE;
    @Length(max=60)
    @Caption(value="Localiza\u00e7\u00e3o")
    private @Length(max=60) String localizacao;
    @Length(max=100)
    @Caption(value="Descri\u00e7\u00e3o Logradouro Inicio")
    private @Length(max=100) String descLogradouroInicio;
    @Caption(value="Inativo")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean inativo;
    @Length(max=100)
    @Caption(value="Descri\u00e7\u00e3o Anterior")
    private @Length(max=100) String descricaoAnterior;
    @Caption(value="Logradouro Inicio")
    private Long logradouroInicio;
    @Caption(value="Data Cria\u00e7\u00e3o")
    private LocalDate dataCriacao;
    @Length(max=100)
    @Caption(value="Programa")
    private @Length(max=100) String programa;
    @Length(max=15)
    @Caption(value="Usu\u00e1rio")
    private @Length(max=15) String usuario;
    @Caption(value="ID \u00danico")
    private Long idunico;

    public TipoLogradouro getTipoLogradouro() {
        return this.tipoLogradouro;
    }

    public void setTipoLogradouro(TipoLogradouro tipoLogradouro) {
        this.tipoLogradouro = tipoLogradouro;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public Boolean getCorreto() {
        return this.correto;
    }

    public void setCorreto(Boolean correto) {
        this.correto = correto;
    }

    public String getLocalizacao() {
        return this.localizacao;
    }

    public void setLocalizacao(String localizacao) {
        this.localizacao = localizacao;
    }

    public String getDescLogradouroInicio() {
        return this.descLogradouroInicio;
    }

    public void setDescLogradouroInicio(String descLogradouroInicio) {
        this.descLogradouroInicio = descLogradouroInicio;
    }

    public Boolean getInativo() {
        return this.inativo;
    }

    public void setInativo(Boolean inativo) {
        this.inativo = inativo;
    }

    public String getDescricaoAnterior() {
        return this.descricaoAnterior;
    }

    public void setDescricaoAnterior(String descricaoAnterior) {
        this.descricaoAnterior = descricaoAnterior;
    }

    public Long getLogradouroInicio() {
        return this.logradouroInicio;
    }

    public void setLogradouroInicio(Long logradouroInicio) {
        this.logradouroInicio = logradouroInicio;
    }

    public LocalDate getDatacriacao() {
        return this.dataCriacao;
    }

    public void setDatacriacao(LocalDate dataCriacao) {
        this.dataCriacao = dataCriacao;
    }

    public String getPrograma() {
        return this.programa;
    }

    public void setPrograma(String programa) {
        this.programa = programa;
    }

    public String getUsuario() {
        return this.usuario;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    public Long getIdunico() {
        return this.idunico;
    }

    public void setIdunico(Long idunico) {
        this.idunico = idunico;
    }

    public Long getId() {
        return this.id;
    }

    public Cidade getCidade() {
        return this.cidade;
    }

    public Long getLogradouro() {
        return this.logradouro;
    }

    public LocalDate getDataCriacao() {
        return this.dataCriacao;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCidade(Cidade cidade) {
        this.cidade = cidade;
    }

    public void setLogradouro(Long logradouro) {
        this.logradouro = logradouro;
    }

    public void setDataCriacao(LocalDate dataCriacao) {
        this.dataCriacao = dataCriacao;
    }

    public String getTipoLogradouroDescricao() {
        if (this.getTipoLogradouro() == null) {
            return "";
        }
        return this.getTipoLogradouro().getDescricao();
    }

    public String toString() {
        return "Logradouro(id=" + this.getId() + ", cidade=" + this.getCidade() + ", logradouro=" + this.getLogradouro() + ", tipoLogradouro=" + this.getTipoLogradouro() + ", descricao=" + this.getDescricao() + ", correto=" + this.getCorreto() + ", localizacao=" + this.getLocalizacao() + ", descLogradouroInicio=" + this.getDescLogradouroInicio() + ", inativo=" + this.getInativo() + ", descricaoAnterior=" + this.getDescricaoAnterior() + ", logradouroInicio=" + this.getLogradouroInicio() + ", dataCriacao=" + this.getDatacriacao() + ", programa=" + this.getPrograma() + ", usuario=" + this.getUsuario() + ", idunico=" + this.getIdunico() + ")";
    }
}

