/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.Cidade;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;

@Entity(name="Entidade")
public class Entidade
implements EloEntity<Long>,
PersistentAttributeInterceptable {
    @Id
    @EloSequence
    @Caption(value="Entidade")
    @Column(name="entidade")
    private Long id;
    @Column(length=100)
    @Caption(value="Nome")
    private String nome;
    @Column(length=60)
    @Caption(value="Complemento")
    private String complemento;
    @Caption(value="Logradouro")
    private Long logradouro;
    @Caption(value="N\u00famero")
    @Column(length=10)
    private String numero;
    @Caption(value="Bairro")
    private Long bairro;
    @ManyToOne
    @JoinColumn(name="cidade", referencedColumnName="cidade")
    private Cidade cidade;
    @Caption(value="CEP")
    @Column(length=10)
    private String cep;
    @Caption(value="CNPJ")
    @Column(length=20)
    private String cnpj;
    @Caption(value="Entidade principal")
    @Column(name="entidadeprincipal", length=1)
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean principal;
    @Caption(value="Tipo da entidade")
    @Column(length=1)
    private String tipoEntidade;
    @Basic(fetch=FetchType.LAZY)
    private byte[] brasao;
    @Caption(value="Telefone")
    @Column(length=20)
    private String telefone;
    @Caption(value="UF")
    @Column(length=2)
    private String unidadeFederacao;
    @Column(length=10)
    private String identificacaoTce;
    @Caption(value="CNAE")
    private Long cnae;
    @Column(length=20)
    private String codigo;
    @Caption(value="Se\u00e7\u00e3o")
    @Column(length=2)
    private String secao;
    @Caption(value="E-mail")
    @Column(length=60)
    private String email;
    private Long gps;
    private Long fpas;
    @Column(length=1)
    private String tipoSistema;
    private BigDecimal percentualIsencaoFilantropica = BigDecimal.ZERO;
    private Long idUnico;
    @Transient
    @MetaModelIgnore
    @JsonIgnore
    private PersistentAttributeInterceptor interceptor;

    public byte[] getBrasao() {
        if (this.interceptor != null) {
            this.brasao = (byte[])this.interceptor.readObject((Object)this, "brasao", (Object)this.brasao);
        }
        return this.brasao;
    }

    public void setBrasao(byte[] brasao) {
        if (this.interceptor != null) {
            this.interceptor.writeObject((Object)this, "brasao", (Object)this.brasao, (Object)brasao);
        }
        this.brasao = brasao;
    }

    public Entidade(Long entidade) {
        this.id = entidade;
    }

    public Boolean contemBrasao() {
        return this.brasao != null;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.interceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public String toString() {
        return "Entidade(id=" + this.getId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Entidade)) {
            return false;
        }
        Entidade other = (Entidade)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Entidade;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    public Long getId() {
        return this.id;
    }

    public String getNome() {
        return this.nome;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public Long getLogradouro() {
        return this.logradouro;
    }

    public String getNumero() {
        return this.numero;
    }

    public Long getBairro() {
        return this.bairro;
    }

    public Cidade getCidade() {
        return this.cidade;
    }

    public String getCep() {
        return this.cep;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public Boolean getPrincipal() {
        return this.principal;
    }

    public String getTipoEntidade() {
        return this.tipoEntidade;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public String getUnidadeFederacao() {
        return this.unidadeFederacao;
    }

    public String getIdentificacaoTce() {
        return this.identificacaoTce;
    }

    public Long getCnae() {
        return this.cnae;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getSecao() {
        return this.secao;
    }

    public String getEmail() {
        return this.email;
    }

    public Long getGps() {
        return this.gps;
    }

    public Long getFpas() {
        return this.fpas;
    }

    public String getTipoSistema() {
        return this.tipoSistema;
    }

    public BigDecimal getPercentualIsencaoFilantropica() {
        return this.percentualIsencaoFilantropica;
    }

    public Long getIdUnico() {
        return this.idUnico;
    }

    public PersistentAttributeInterceptor getInterceptor() {
        return this.interceptor;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public void setLogradouro(Long logradouro) {
        this.logradouro = logradouro;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public void setBairro(Long bairro) {
        this.bairro = bairro;
    }

    public void setCidade(Cidade cidade) {
        this.cidade = cidade;
    }

    public void setCep(String cep) {
        this.cep = cep;
    }

    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    public void setTipoEntidade(String tipoEntidade) {
        this.tipoEntidade = tipoEntidade;
    }

    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    public void setUnidadeFederacao(String unidadeFederacao) {
        this.unidadeFederacao = unidadeFederacao;
    }

    public void setIdentificacaoTce(String identificacaoTce) {
        this.identificacaoTce = identificacaoTce;
    }

    public void setCnae(Long cnae) {
        this.cnae = cnae;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public void setSecao(String secao) {
        this.secao = secao;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setGps(Long gps) {
        this.gps = gps;
    }

    public void setFpas(Long fpas) {
        this.fpas = fpas;
    }

    public void setTipoSistema(String tipoSistema) {
        this.tipoSistema = tipoSistema;
    }

    public void setPercentualIsencaoFilantropica(BigDecimal percentualIsencaoFilantropica) {
        this.percentualIsencaoFilantropica = percentualIsencaoFilantropica;
    }

    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    public void setInterceptor(PersistentAttributeInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public Entidade() {
    }
}

