/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.DocumentoFinalidade;
import br.com.elotech.tributos.domain.DocumentoTipo;
import br.com.elotech.tributos.domain.EntidadeTributacao;
import br.com.elotech.tributos.domain.Pessoa;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TRIBDOCUMENTO")
public class Documento
implements EloEntity<Long> {
    @Id
    @Column(name="idkey")
    @EloSequence(sequenceName="S_TRIBDOCUMENTO_ID")
    private Long id;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBENTIDADETRIBUTACAO_IDKEY")
    private EntidadeTributacao entidadeTributacao;
    @NotNull
    @ManyToOne
    private DocumentoTipo tipoDocumento;
    @NotNull
    @EloSequence
    private Long documento;
    @NotNull
    private Integer exercicio;
    @Length(max=20)
    @Column(name="CNPJ_CPF")
    private @Length(max=20) String cnpjCpf;
    private LocalDate dataEmissao;
    private LocalDate dataValidade;
    @Length(max=150)
    private @Length(max=150) String outraFinalidade;
    @ManyToOne
    @JoinColumn(name="TRIBCADASTROGERAL_IDKEY")
    private CadastroGeral cadastroGeral;
    @Length(max=150)
    private @Length(max=150) String requerente;
    @Length(max=20)
    private @Length(max=20) String cpfRequerente;
    private TipoPessoa tipoPessoaRequerente;
    @Length(max=1)
    private @Length(max=1) String subTipo;
    @Length(max=100)
    private @Length(max=100) String codigoValidacao;
    @ManyToOne
    @JoinColumn(name="TRIBDOCUMENTOFINALIDADE_IDKEY")
    private DocumentoFinalidade sequenciaFinalidade;
    @ManyToOne
    private Pessoa pessoa;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean cancelado;

    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(LocalDate dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    public LocalDate getDataValidade() {
        return this.dataValidade;
    }

    public void setDataValidade(LocalDate dataValidade) {
        this.dataValidade = dataValidade;
    }

    public String getOutraFinalidade() {
        return this.outraFinalidade;
    }

    public void setOutraFinalidade(String outraFinalidade) {
        this.outraFinalidade = outraFinalidade;
    }

    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    public String getRequerente() {
        return this.requerente;
    }

    public void setRequerente(String requerente) {
        this.requerente = requerente;
    }

    public String getCpfRequerente() {
        return this.cpfRequerente;
    }

    public void setCpfRequerente(String cpfRequerente) {
        this.cpfRequerente = cpfRequerente;
    }

    public TipoPessoa getTipoPessoaRequerente() {
        return this.tipoPessoaRequerente;
    }

    public void setTipoPessoaRequerente(TipoPessoa tipoPessoaRequerente) {
        this.tipoPessoaRequerente = tipoPessoaRequerente;
    }

    public String getSubTipo() {
        return this.subTipo;
    }

    public void setSubTipo(String subTipo) {
        this.subTipo = subTipo;
    }

    public String getCodigoValidacao() {
        return this.codigoValidacao;
    }

    public void setCodigoValidacao(String codigoValidacao) {
        this.codigoValidacao = codigoValidacao;
    }

    public DocumentoFinalidade getSequenciaFinalidade() {
        return this.sequenciaFinalidade;
    }

    public void setSequenciaFinalidade(DocumentoFinalidade sequenciaFinalidade) {
        this.sequenciaFinalidade = sequenciaFinalidade;
    }

    public Long getId() {
        return this.id;
    }

    public EntidadeTributacao getEntidadeTributacao() {
        return this.entidadeTributacao;
    }

    public DocumentoTipo getTipoDocumento() {
        return this.tipoDocumento;
    }

    public Long getDocumento() {
        return this.documento;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setEntidadeTributacao(EntidadeTributacao entidadeTributacao) {
        this.entidadeTributacao = entidadeTributacao;
    }

    public void setTipoDocumento(DocumentoTipo tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
    }

    public void setDocumento(Long documento) {
        this.documento = documento;
    }

    public Integer getExercicio() {
        return this.exercicio;
    }

    public void setExercicio(Integer exercicio) {
        this.exercicio = exercicio;
    }

    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    public Boolean getCancelado() {
        return this.cancelado;
    }

    public void setCancelado(Boolean cancelado) {
        this.cancelado = cancelado;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Documento)) {
            return false;
        }
        Documento other = (Documento)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Documento;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

