/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.utils.GeraImagemCodigoBarras;
import br.com.elotech.tributos.converter.OrigemEmissaoConverter;
import br.com.elotech.tributos.converter.TipoBloquetoConverter;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoBloqueto;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TRIBBLOQUETO")
public class Bloqueto
implements EloEntity<Long> {
    @Id
    @Column(name="idkey")
    @EloSequence(sequenceName="S_TRIBBLOQUETO_ID")
    private Long id;
    @NotNull
    private Long entidade;
    @NotNull
    private Long exercicioBloqueto;
    @NotNull
    private Long bloqueto;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="pessoa", referencedColumnName="pessoa", updatable=false, nullable=false)
    private Pessoa pessoa;
    @Length(max=20)
    private @Length(max=20) String campo1;
    @Length(max=20)
    private @Length(max=20) String campo2;
    @Length(max=20)
    private @Length(max=20) String campo3;
    @Length(max=20)
    private @Length(max=20) String campo4;
    @Length(max=20)
    private @Length(max=20) String campo5;
    @Column(name="codigo_baixa")
    private BigDecimal codigoBaixa;
    @Length(max=100)
    private @Length(max=100) String codigoBarras;
    @Length(max=100)
    private @Length(max=100) String codigoBarrasExterno;
    @Length(max=60)
    private @Length(max=60) String codigoBarrasFormatado;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Corrigido")
    private Boolean corrigido = Boolean.FALSE;
    private LocalDate dataEmissao;
    private LocalDate dataLimitePagamento;
    private LocalDate dataVencimento;
    @Length(max=1)
    private @Length(max=1) String direitoDescontoCotaUnica;
    private Integer formaPagamento;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Impresso")
    private Boolean impresso = Boolean.FALSE;
    private Integer modeloBloqueto;
    private Integer motivoDesconto;
    @Length(max=40)
    private @Length(max=40) String nossoNumero;
    private Integer numeroImpressao;
    @Length(max=4000)
    private @Length(max=4000) String observacao;
    @Convert(converter=OrigemEmissaoConverter.class)
    private OrigemEmissao origemEmissao;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Pago")
    private Boolean pago = Boolean.FALSE;
    @Column(name="sub_seq_pref")
    private Integer subSeqPref;
    @Convert(converter=TipoBloquetoConverter.class)
    private TipoBloqueto tipoBloqueto;
    @Length(max=15)
    private @Length(max=15) String usuario;
    @Length(max=1)
    private @Length(max=1) String utilizaValorBloqueto;
    @Column(name="ano_div_pref")
    private Integer anoDivPref;
    @Length(max=1)
    private @Length(max=1) String bloquetoGeradoBaixaAutomatica;
    private Integer cadastroInvalido;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;
    private BigDecimal valorDesconto = BigDecimal.ZERO;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorPrincipal = BigDecimal.ZERO;
    @Length(max=100)
    private @Length(max=100) String codigoValidacao;

    public Long getId() {
        return this.id;
    }

    public Integer getAnoDivPref() {
        return this.anoDivPref;
    }

    public String getBloquetoGeradoBaixaAutomatica() {
        return this.bloquetoGeradoBaixaAutomatica;
    }

    public Integer getCadastroInvalido() {
        return this.cadastroInvalido;
    }

    public String getLinhaDigitavel() {
        return this.getCampo1().concat(this.getCampo2()).concat(this.getCampo3()).concat(this.getCampo4()).concat(this.getCampo5());
    }

    public byte[] getCodigoBarrasImagem() {
        return GeraImagemCodigoBarras.getImagemAsPNG((String)this.codigoBarras);
    }

    public String getCampo1() {
        return Optional.ofNullable(this.campo1).orElse("");
    }

    public String getCampo2() {
        return Optional.ofNullable(this.campo2).orElse("");
    }

    public String getCampo3() {
        return Optional.ofNullable(this.campo3).orElse("");
    }

    public String getCampo4() {
        return Optional.ofNullable(this.campo4).orElse("");
    }

    public String getCampo5() {
        return Optional.ofNullable(this.campo5).orElse("");
    }

    public BigDecimal getCodigoBaixa() {
        return this.codigoBaixa;
    }

    public String getCodigoBarras() {
        return this.codigoBarras;
    }

    public String getCodigoBarrasExterno() {
        return this.codigoBarrasExterno;
    }

    public String getCodigoBarrasFormatado() {
        return this.codigoBarrasFormatado;
    }

    public Boolean getCorrigido() {
        return this.corrigido;
    }

    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    public LocalDate getDataLimitePagamento() {
        return this.dataLimitePagamento;
    }

    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    public String getDireitoDescontoCotaUnica() {
        return this.direitoDescontoCotaUnica;
    }

    public Integer getFormaPagamento() {
        return this.formaPagamento;
    }

    public Boolean getImpresso() {
        return this.impresso;
    }

    public Integer getModeloBloqueto() {
        return this.modeloBloqueto;
    }

    public Integer getMotivoDesconto() {
        return this.motivoDesconto;
    }

    public String getNossoNumero() {
        return this.nossoNumero;
    }

    public Integer getNumeroImpressao() {
        return this.numeroImpressao;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public OrigemEmissao getOrigemEmissao() {
        return this.origemEmissao;
    }

    public Boolean getPago() {
        return this.pago;
    }

    public Integer getSubSeqPref() {
        return this.subSeqPref;
    }

    public TipoBloqueto getTipoBloqueto() {
        return this.tipoBloqueto;
    }

    public String getUsuario() {
        return this.usuario;
    }

    public String getUtilizaValorBloqueto() {
        return this.utilizaValorBloqueto;
    }

    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    public BigDecimal getValorDesconto() {
        return this.valorDesconto;
    }

    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    public BigDecimal getValorPrincipal() {
        return this.valorPrincipal;
    }

    public BigDecimal getValorBloqueto() {
        BigDecimal valorBloqueto = BigDecimal.ZERO;
        valorBloqueto = valorBloqueto.add(this.getValorPrincipal()).add(this.getValorMulta()).add(this.getValorJuros()).add(this.getValorCorrecao()).subtract(this.getValorDesconto());
        return valorBloqueto;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setAnoDivPref(Integer anoDivPref) {
        this.anoDivPref = anoDivPref;
    }

    public void setBloquetoGeradoBaixaAutomatica(String bloquetoGeradoBaixaAutomatica) {
        this.bloquetoGeradoBaixaAutomatica = bloquetoGeradoBaixaAutomatica;
    }

    public void setCadastroInvalido(Integer cadastroInvalido) {
        this.cadastroInvalido = cadastroInvalido;
    }

    public void setCampo1(String campo1) {
        this.campo1 = campo1;
    }

    public void setCampo2(String campo2) {
        this.campo2 = campo2;
    }

    public void setCampo3(String campo3) {
        this.campo3 = campo3;
    }

    public void setCampo4(String campo4) {
        this.campo4 = campo4;
    }

    public void setCampo5(String campo5) {
        this.campo5 = campo5;
    }

    public void setCodigoBaixa(BigDecimal codigoBaixa) {
        this.codigoBaixa = codigoBaixa;
    }

    public void setCodigoBarras(String codigoBarras) {
        this.codigoBarras = codigoBarras;
    }

    public void setCodigoBarrasExterno(String codigoBarrasExterno) {
        this.codigoBarrasExterno = codigoBarrasExterno;
    }

    public void setCodigoBarrasFormatado(String codigoBarrasFormatado) {
        this.codigoBarrasFormatado = codigoBarrasFormatado;
    }

    public void setCorrigido(Boolean corrigido) {
        this.corrigido = corrigido;
    }

    public void setDataEmissao(LocalDate dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    public void setDataLimitePagamento(LocalDate dataLimitePagamento) {
        this.dataLimitePagamento = dataLimitePagamento;
    }

    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    public void setDireitoDescontoCotaUnica(String direitoDescontoCotaUnica) {
        this.direitoDescontoCotaUnica = direitoDescontoCotaUnica;
    }

    public void setFormaPagamento(Integer formaPagamento) {
        this.formaPagamento = formaPagamento;
    }

    public void setImpresso(Boolean impresso) {
        this.impresso = impresso;
    }

    public void setModeloBloqueto(Integer modeloBloqueto) {
        this.modeloBloqueto = modeloBloqueto;
    }

    public void setMotivoDesconto(Integer motivoDesconto) {
        this.motivoDesconto = motivoDesconto;
    }

    public void setNossoNumero(String nossoNumero) {
        this.nossoNumero = nossoNumero;
    }

    public void setNumeroImpressao(Integer numeroImpressao) {
        this.numeroImpressao = numeroImpressao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public void setOrigemEmissao(OrigemEmissao origemEmissao) {
        this.origemEmissao = origemEmissao;
    }

    public void setPago(Boolean pago) {
        this.pago = pago;
    }

    public void setSubSeqPref(Integer subSeqPref) {
        this.subSeqPref = subSeqPref;
    }

    public void setTipoBloqueto(TipoBloqueto tipoBloqueto) {
        this.tipoBloqueto = tipoBloqueto;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    public void setUtilizaValorBloqueto(String utilizaValorBloqueto) {
        this.utilizaValorBloqueto = utilizaValorBloqueto;
    }

    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    public void setValorDesconto(BigDecimal valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    public void setValorPrincipal(BigDecimal valorPrincipal) {
        this.valorPrincipal = valorPrincipal;
    }

    public Long getEntidade() {
        return this.entidade;
    }

    public Long getExercicioBloqueto() {
        return this.exercicioBloqueto;
    }

    public Long getBloqueto() {
        return this.bloqueto;
    }

    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    public void setExercicioBloqueto(Long exercicioBloqueto) {
        this.exercicioBloqueto = exercicioBloqueto;
    }

    public void setBloqueto(Long bloqueto) {
        this.bloqueto = bloqueto;
    }

    public String getCodigoValidacao() {
        return this.codigoValidacao;
    }

    public void setCodigoValidacao(String codigoValidacao) {
        this.codigoValidacao = codigoValidacao;
    }

    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }
}

