select ger.tipocadastro,
       ger.cadastrogeral,
       pes.pessoa,
       pes.nome,
       pes.cnpj_cpf as cpfCnpj,
       logr.descricao as rua,
       ger.numero,
       ger.complemento,
       ger.cep,
       cid.descricao as cidade,
       uni.descricao as estado
from pessoa pes
inner join tribproprietario prop on prop.pessoa = pes.pessoa
inner join tribcadastrogeral ger on ger.tipocadastro  = prop.tipocadastro
                                and ger.cadastrogeral = prop.cadastrogeral
left outer join logradouro logr on logr.cidade     = ger.cidade
                               and logr.logradouro = ger.logradouro
left outer join cidade cid on cid.cidade = ger.cidade
left outer join unidadefederacao uni on uni.unidadefederacao = cid.unidadefederacao
                                    and uni.pais = cid.pais
where pes.cnpj_cpf = ?
and   exists (select 1
              from tribdebito deb
              inner join tribdebitoparcela par on par.entidade         = deb.entidade
                                              and par.exercicio        = deb.exercicio
                                              and par.tipocadastro     = deb.tipocadastro
                                              and par.cadastrogeral    = deb.cadastrogeral
                                              and par.guiarecolhimento = deb.guiarecolhimento
                                              and par.subdivida        = deb.subdivida
              inner join tribsituacaoparcela sit on sit.situacaoparcela = par.situacaodebito
              inner join tribtiposituacaoparcela tip on tip.tiposituacaoparcela = sit.situacaoparcela
              where deb.tipocadastro  = ger.tipocadastro
              and   deb.cadastrogeral = ger.cadastrogeral
              and   deb.constituido   = 'S'
              and   tip.tipo = 'A')