/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.ws.domain;

import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.dto.DocumentoDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="GeraLaudoAvaliacaoImobiliario", namespace="urn:uAiseServiceTributosIntf-IIAiseServiceTributos")
public class GeraLaudoAvaliacaoEnvio {
    private static final Long DOCUMENTO_PADRAO = 0L;
    @XmlElement(required=false, name="AUserKey")
    private String userKey;
    @XmlElement(required=false, name="ATipoCadastro")
    private Long tipoCadastro = TipoCadastro.IMOBILIARIO.getValue();
    @XmlElement(required=false, name="ACadastroGeral")
    private Long cadastroGeral;
    @XmlElement(required=false, name="AExercicio")
    private final Long exercicio;
    @XmlElement(required=false, name="ATipoDocumento")
    private Long tipoDocumento = TipoDocumentoEnum.LAUDO_AVALIACAO.getCodigo();
    @XmlElement(required=false, name="ADocumento")
    private Long documento = DOCUMENTO_PADRAO;
    @XmlElement(required=false, name="AValorVenalInformado")
    private BigDecimal valorVenalInformado;
    @XmlElement(required=false, name="ANomeRequerente")
    private String nomeRequerente;
    @XmlElement(required=false, name="ACpfRequerente")
    private String cpfRequerente;

    public GeraLaudoAvaliacaoEnvio() {
        this.exercicio = LocalDate.now().getYear();
    }

    public GeraLaudoAvaliacaoEnvio(Long cadastroGeral, String userKey, Long exercicio) {
        this.cadastroGeral = cadastroGeral;
        this.userKey = userKey;
        this.exercicio = exercicio;
    }

    public GeraLaudoAvaliacaoEnvio(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
        this.exercicio = LocalDate.now().getYear();
    }

    public GeraLaudoAvaliacaoEnvio(DocumentoDTO dto) {
        this.cadastroGeral = dto.getCadastroGeral();
        this.valorVenalInformado = dto.getValorVenalInformado();
        this.nomeRequerente = dto.getNomeRequerente();
        this.cpfRequerente = dto.getCpfRequerente();
        this.exercicio = LocalDate.now().getYear();
    }

    public String getUserKey() {
        return this.userKey;
    }

    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    public Long getExercicio() {
        return this.exercicio;
    }

    public Long getTipoDocumento() {
        return this.tipoDocumento;
    }

    public void setTipoDocumento(Long tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
    }

    public Long getDocumento() {
        return this.documento;
    }

    public void setDocumento(Long documento) {
        this.documento = documento;
    }

    public BigDecimal getValorVenalInformado() {
        return this.valorVenalInformado;
    }

    public void setValorVenalInformado(BigDecimal valorVenalInformado) {
        this.valorVenalInformado = valorVenalInformado;
    }

    public String getNomeRequerente() {
        return this.nomeRequerente;
    }

    public void setNomeRequerente(String nomeRequerente) {
        this.nomeRequerente = nomeRequerente;
    }

    public String getCpfRequerente() {
        return this.cpfRequerente;
    }

    public void setCpfRequerente(String cpfRequerente) {
        this.cpfRequerente = cpfRequerente;
    }
}

