/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.rest;

import br.com.elotech.tributos.config.TributosProperties;
import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.dto.DebitoHandler;
import br.com.elotech.tributos.dto.IdDebitoDTO;
import br.com.elotech.tributos.dto.mobile.DebitoMobileDTO;
import br.com.elotech.tributos.dto.mobile.DebitoParcelaMobileDTO;
import br.com.elotech.tributos.params.CadastroGeralParams;
import br.com.elotech.tributos.repository.DebitoRepository;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.ws.rest.AiseLoginServiceRest;
import br.com.elotech.tributos.ws.domain.LoginRespostaRest;
import br.com.elotech.tributos.ws.rest.dto.DebitoMapper;
import br.com.elotech.tributos.ws.rest.dto.DebitoTransportDTO;
import br.com.elotech.tributos.ws.rest.dto.GerarDebitoRequestDTO;
import br.com.elotech.tributos.ws.rest.dto.GerarDebitoResponseDTO;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.server.ResponseStatusException;

@Service
@Profile(value={"rest"})
public class AiseDebitoServiceRest
implements DebitoService {
    private final RestTemplate restTemplate;
    private final AiseLoginServiceRest aiseLoginServiceRest;
    private final CadastroGeralService cadastroGeralService;
    private final String urlGetDebitos;
    private final String urlGetDebitosPorId;
    private final String urlGetDebitosPorIdParcelamento;
    private final String urlGeraDebito;
    private final DebitoMapper debitoMapper;
    private final DebitoRepository debitoRepository;
    private static final String AUTHORIZATION = "Authorization";
    private static final String BEARER = "Bearer ";
    private static final Integer IN_STATEMENT_MAX_LENGTH = 999;

    public AiseDebitoServiceRest(RestTemplate restTemplate, TributosProperties tributosProperties, AiseLoginServiceRest aiseLoginServiceRest, CadastroGeralService cadastroGeralService, DebitoMapper debitoMapper, DebitoRepository debitoRepository) {
        this.aiseLoginServiceRest = aiseLoginServiceRest;
        this.cadastroGeralService = cadastroGeralService;
        this.restTemplate = restTemplate;
        this.urlGetDebitos = tributosProperties.getAise().getBaseUrl() + "/datasnap/rest/tdebitos/emaberto/";
        this.urlGetDebitosPorId = tributosProperties.getAise().getBaseUrl() + "/datasnap/rest/tdebitos/emabertoporid/";
        this.urlGetDebitosPorIdParcelamento = tributosProperties.getAise().getBaseUrl() + "/datasnap/rest/tdebitos/emabertoporidparcelamento/";
        this.urlGeraDebito = tributosProperties.getAise().getBaseUrl() + "/datasnap/rest/tdebitos/gerar";
        this.debitoMapper = debitoMapper;
        this.debitoRepository = debitoRepository;
    }

    public List<DebitoDTO> getDebitos(CadastroGeralParams params) {
        DebitoTransportDTO delphiDTO = this.getDebitosEmAberto(params);
        return delphiDTO.getList().getItems().stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoDTO(arg_0)).collect(Collectors.toList());
    }

    private DebitoTransportDTO getDebitosEmAberto(CadastroGeralParams params) {
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        this.cadastroGeralService.validaCadastroGeral(params.getTipoCadastro(), params.getCadastroGeral());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set(AUTHORIZATION, BEARER + loginResposta.getIdToken());
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(this.urlGetDebitos + params.getTipoCadastro().getValue().toString() + "/" + params.getCadastroGeral().toString(), HttpMethod.GET, entity, DebitoTransportDTO.class, new Object[0]);
        return (DebitoTransportDTO)response.getBody();
    }

    private DebitoTransportDTO getDebitosEmAbertoPorId(Long idDebito) {
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set(AUTHORIZATION, BEARER + loginResposta.getIdToken());
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(this.urlGetDebitosPorId + idDebito.toString(), HttpMethod.GET, entity, DebitoTransportDTO.class, new Object[0]);
        return (DebitoTransportDTO)response.getBody();
    }

    private DebitoTransportDTO getDebitosEmAbertoPorIdParcelamento(Long idParcelamento) {
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set(AUTHORIZATION, BEARER + loginResposta.getIdToken());
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(this.urlGetDebitosPorIdParcelamento + idParcelamento.toString(), HttpMethod.GET, entity, DebitoTransportDTO.class, new Object[0]);
        return (DebitoTransportDTO)response.getBody();
    }

    public List<DebitoDTO> getDebitosAgrupados(CadastroGeralParams params) {
        DebitoTransportDTO delphiDTO = this.getDebitosEmAberto(params);
        return DebitoHandler.agrupaContratoParcela(delphiDTO.getList().getItems().stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoDTO(arg_0)).collect(Collectors.toList()));
    }

    public List<DebitoMobileDTO> getDebitosMobile(CadastroGeralParams params) {
        DebitoTransportDTO delphiDTO = this.getDebitosEmAberto(params);
        List listDebitosAgrupados = DebitoHandler.agrupaDebitoMobile(delphiDTO.getList().getItems().stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoDTO(arg_0)).collect(Collectors.toList()));
        return listDebitosAgrupados.stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoMobileDTO(arg_0)).collect(Collectors.toList());
    }

    public List<DebitoParcelaMobileDTO> getParcelas(Long idDebito) {
        DebitoTransportDTO debitos = this.getDebitosEmAbertoPorId(idDebito);
        return debitos.getList().getItems().stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoParcelaMobileDTO(arg_0)).collect(Collectors.toList());
    }

    public List<DebitoParcelaMobileDTO> getParcelasParcelamento(Long idParcelamento) {
        DebitoTransportDTO delphiDTO = this.getDebitosEmAbertoPorIdParcelamento(idParcelamento);
        List listDebitosAgrupados = DebitoHandler.agrupaContratoParcela(delphiDTO.getList().getItems().stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoDTO(arg_0)).filter(DebitoDTO::getEmiteBloqueto).collect(Collectors.toList()));
        return listDebitosAgrupados.stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoParcelaMobileDTO(arg_0)).collect(Collectors.toList());
    }

    public GerarDebitoResponseDTO geraDebito(GerarDebitoRequestDTO debito) {
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set(AUTHORIZATION, BEARER + loginResposta.getIdToken());
        HttpEntity entity = new HttpEntity((Object)debito, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(this.urlGeraDebito, HttpMethod.POST, entity, GerarDebitoResponseDTO.class, new Object[0]);
        if (((GerarDebitoResponseDTO)response.getBody()).getIdDebito() == 0L) {
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, "N\u00e3o foi poss\u00edvel gerar o d\u00e9bito.");
        }
        return (GerarDebitoResponseDTO)response.getBody();
    }

    public List<IdDebitoDTO> verificarPagos(List<IdDebitoDTO> listIdDebito) {
        List partitions = Lists.partition(listIdDebito.stream().map(IdDebitoDTO::getIdDebito).filter(Objects::nonNull).collect(Collectors.toList()), (int)IN_STATEMENT_MAX_LENGTH);
        return partitions.stream().map(arg_0 -> ((DebitoRepository)this.debitoRepository).findPagos(arg_0)).flatMap(Collection::stream).map(IdDebitoDTO::new).collect(Collectors.toList());
    }
}

