/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.rest;

import br.com.elotech.tributos.config.TributosProperties;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.DebitoAutomaticoDTO;
import br.com.elotech.tributos.params.CadastroGeralParams;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.DebitoAutomaticoService;
import br.com.elotech.tributos.service.ws.impl.DebitosToDebitoAutomatico;
import br.com.elotech.tributos.service.ws.rest.AiseLoginServiceRest;
import br.com.elotech.tributos.ws.domain.LoginRespostaRest;
import br.com.elotech.tributos.ws.rest.dto.DebitoMapper;
import br.com.elotech.tributos.ws.rest.dto.DebitoTransportDTO;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
@Profile(value={"rest"})
public class AiseDebitoAutomaticoServiceRest
implements DebitoAutomaticoService {
    private final RestTemplate restTemplate;
    private final AiseLoginServiceRest aiseLoginServiceRest;
    private final CadastroGeralService cadastroGeralService;
    private final TributosProperties tributosProperties;
    private final DebitoMapper debitoMapper;

    public AiseDebitoAutomaticoServiceRest(RestTemplate restTemplate, AiseLoginServiceRest aiseLoginServiceRest, CadastroGeralService cadastroGeralService, TributosProperties tributosProperties, DebitoMapper debitoMapper) {
        this.restTemplate = restTemplate;
        this.aiseLoginServiceRest = aiseLoginServiceRest;
        this.cadastroGeralService = cadastroGeralService;
        this.tributosProperties = tributosProperties;
        this.debitoMapper = debitoMapper;
    }

    public List<DebitoAutomaticoDTO> getDebitosPassiveisDebitosAutomatico(CadastroGeralParams params) {
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        this.cadastroGeralService.validaCadastroGeral(params.getTipoCadastro(), params.getCadastroGeral());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + loginResposta.getIdToken());
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(this.tributosProperties.getAise().getBaseUrl() + "/datasnap/rest/tdebitos/debitoautomatico" + "/" + params.getTipoCadastro().getValue().toString() + "/" + params.getCadastroGeral().toString(), HttpMethod.GET, entity, DebitoTransportDTO.class, new Object[0]);
        DebitoTransportDTO delphiDTO = (DebitoTransportDTO)response.getBody();
        return new DebitosToDebitoAutomatico().agruparESomar(delphiDTO.getList().getItems().stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoDTO(arg_0)).collect(Collectors.toList()));
    }

    public DebitoAutomaticoDTO getDebitoAutomatico(Long exercicio, TipoCadastro tipoCadastro, Long cadastroGeral, Long guiaRecolhimento, Long subDivida) {
        DebitoAutomaticoDTO debitoAutomaticoResult = new DebitoAutomaticoDTO();
        CadastroGeralParams params = new CadastroGeralParams();
        params.setTipoCadastro(tipoCadastro);
        params.setCadastroGeral(cadastroGeral);
        List listDebitoAutomatico = this.getDebitosPassiveisDebitosAutomatico(params);
        for (DebitoAutomaticoDTO debitoAutomaticoDTO : listDebitoAutomatico) {
            if (debitoAutomaticoDTO.getPk().getExercicio().longValue() != exercicio.longValue() || debitoAutomaticoDTO.getPk().getTipoCadastro().intValue() != tipoCadastro.getValue().intValue() || debitoAutomaticoDTO.getPk().getCadastroGeral().longValue() != cadastroGeral.longValue() || debitoAutomaticoDTO.getPk().getGuiaRecolhimento().longValue() != guiaRecolhimento.longValue() || debitoAutomaticoDTO.getPk().getSubDivida().longValue() != subDivida.longValue()) continue;
            debitoAutomaticoResult = debitoAutomaticoDTO;
        }
        return debitoAutomaticoResult;
    }
}

