/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.rest;

import br.com.elotech.tributos.config.TributosProperties;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.params.CertidaoParams;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.CertidaoService;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import br.com.elotech.tributos.service.ws.rest.AiseLoginServiceRest;
import br.com.elotech.tributos.ws.domain.GeraCertidaoEnvio;
import br.com.elotech.tributos.ws.domain.GeraCertidaoResposta;
import br.com.elotech.tributos.ws.domain.LoginRespostaRest;
import br.com.elotech.tributos.ws.function.CertidaoParamsToGeraCertidaoEnvio;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
@Profile(value={"rest"})
public class AiseCertidaoServiceRest
implements CertidaoService {
    private final RestTemplate restTemplate;
    private final TributosProperties tributosProperties;
    private final AiseLoginServiceRest aiseLoginServiceRest;
    private final CadastroGeralService cadastroGeralService;

    public AiseCertidaoServiceRest(RestTemplate restTemplate, TributosProperties tributosProperties, AiseLoginServiceRest aiseLoginServiceRest, CadastroGeralService cadastroGeralService) {
        this.restTemplate = restTemplate;
        this.tributosProperties = tributosProperties;
        this.aiseLoginServiceRest = aiseLoginServiceRest;
        this.cadastroGeralService = cadastroGeralService;
    }

    public GeraCertidaoResposta geraCertidao(CertidaoParams params) {
        if (params.getCadastroGeral() != null && !this.cadastroGeralService.exists(TipoCadastro.fromValue((Long)params.getTipoCadastro().longValue()), params.getCadastroGeral()).booleanValue()) {
            throw new CadastroNaoEncontradoException(TipoCadastro.fromValue((Long)params.getTipoCadastro().longValue()), params.getCadastroGeral());
        }
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + loginResposta.getIdToken());
        CertidaoParamsToGeraCertidaoEnvio toGeraCertidaoEnvio = new CertidaoParamsToGeraCertidaoEnvio();
        GeraCertidaoEnvio wsParams = toGeraCertidaoEnvio.apply(params);
        HttpEntity entity = new HttpEntity((Object)wsParams, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(this.tributosProperties.getAise().getBaseUrl() + "/datasnap/rest/tcertidao/gerar/", HttpMethod.POST, entity, GeraCertidaoResposta.class, new Object[0]);
        return (GeraCertidaoResposta)response.getBody();
    }
}

