/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.rest;

import br.com.elotech.tributos.config.TributosProperties;
import br.com.elotech.tributos.dto.CarneDTO;
import br.com.elotech.tributos.service.CarneService;
import br.com.elotech.tributos.service.ws.rest.AiseLoginServiceRest;
import br.com.elotech.tributos.ws.domain.LoginRespostaRest;
import br.com.elotech.tributos.ws.mapper.AiseWSMapper;
import br.com.elotech.tributos.ws.rest.dto.DebitoCarneDTO;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
@Profile(value={"rest"})
public class AiseCarneServiceRest
implements CarneService {
    private final AiseLoginServiceRest aiseLoginServiceRest;
    private final TributosProperties tributosProperties;
    private final RestTemplate restTemplate;
    private final AiseWSMapper aiseWSMapper;

    public AiseCarneServiceRest(AiseLoginServiceRest aiseLoginServiceRest, TributosProperties tributosProperties, RestTemplate restTemplate, AiseWSMapper aiseWSMapper) {
        this.aiseLoginServiceRest = aiseLoginServiceRest;
        this.tributosProperties = tributosProperties;
        this.restTemplate = restTemplate;
        this.aiseWSMapper = aiseWSMapper;
    }

    public CarneDTO geraCarne(DebitoCarneDTO params) {
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + loginResposta.getIdToken());
        String debitosDelphi = this.aiseWSMapper.toEnvioRest(params);
        HttpEntity entity = new HttpEntity((Object)debitosDelphi, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(this.tributosProperties.getAise().getBaseUrl() + "/datasnap/rest/tcarnes/gerar/", HttpMethod.POST, entity, CarneDTO.class, new Object[0]);
        return (CarneDTO)response.getBody();
    }
}

