/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.impl;

import br.com.elotech.tributos.config.TributosProperties;
import br.com.elotech.tributos.service.ws.AiseLoginService;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.util.LoggerPrototype;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class AisePdfServiceImpl
implements LoggerPrototype,
AisePdfService {
    private static final Logger LOG = LoggerFactory.getLogger(AisePdfServiceImpl.class);
    private static final String CARNE = "/imprimircarne?uid={UUID}&value={VALUE}";
    private static final String BLOQUETO = "/imprimirbloqueto?uid={UUID}&value={VALUE}";
    private static final String BLOQUETO_ITBI = "/imprimirbloquetoitbi?uid={UUID}&bloqueto={bloqueto}&idsequencia={idsequencia}&tiporelatorio={tiporelatorio}&relatorio={relatorio}";
    private static final String DOCUMENTO = "/imprimirdocumento?uid={UUID}&value={VALUE}&valuetipo={VALUETIPO}&valueexercicio={VALUEEXERCICIO}";
    private static final String DEBITO = "/imprimirdebitos?uid={UUID}&tipocadastro={tipocadastro}&cadastrogeral={cadastrogeral}";
    private static final String SITUACAOBYCADASTRO = "/imprimirsituacaocadastral?uid={UUID}&tipocadastro={tipocadastro}&cadastrogeral={cadastrogeral}&cnpjcpf=null&tipopessoa=null";
    private static final String SITUACAOBYCNPJ = "/imprimirsituacaocadastral?uid={UUID}&tipocadastro=0&cadastrogeral=0&cnpjcpf={cnpjcpf}&tipopessoa={tipopessoa}";
    private final RestTemplate restTemplate;
    private final TributosProperties tributosProperties;
    private final AiseLoginService aiseLoginService;

    public AisePdfServiceImpl(RestTemplate restTemplate, TributosProperties tributosProperties, AiseLoginService aiseLoginService) {
        this.restTemplate = restTemplate;
        this.tributosProperties = tributosProperties;
        this.aiseLoginService = aiseLoginService;
    }

    private String fetch(String tipoRequisicaoDocumento, Object ... params) {
        Object[] callParams = ArrayUtils.add((Object[])params, (int)0, (Object)this.aiseLoginService.login().getUserKey());
        LOG.debug("P\u00e2rametros recebidos para gerar pdf: {} ", callParams);
        String requestUrl = this.tributosProperties.getAise().getExternalUrl().concat(tipoRequisicaoDocumento);
        LOG.debug("ExternalUrl retornada para gerar relat\u00f3rio: {}", (Object)requestUrl);
        return this.restTemplate.getUriTemplateHandler().expand(requestUrl, callParams).toString();
    }

    public String fetchCarne(Long value) {
        return this.fetch(CARNE, new Object[]{value});
    }

    public String fetchBloqueto(Long value) {
        return this.fetch(BLOQUETO, new Object[]{value});
    }

    public String fetchDocumento(Long value, Integer valueTipo, Integer exercicio) {
        return this.fetch(DOCUMENTO, new Object[]{value, valueTipo, exercicio});
    }

    public String fetchDebitos(Integer tipoCadastro, Long cadastroGeral) {
        return this.fetch(DEBITO, new Object[]{tipoCadastro, cadastroGeral});
    }

    public String fetchSituacaoCadastralByCadastro(Integer tipoCadastro, Long cadastroGeral) {
        return this.fetch(SITUACAOBYCADASTRO, new Object[]{tipoCadastro, cadastroGeral});
    }

    public String fetchSituacaoCadastralByCnpj(String tipoPessoa, String cnpjCpf) {
        return this.fetch(SITUACAOBYCNPJ, new Object[]{cnpjCpf, tipoPessoa});
    }

    public String fetchBloquetoItbi(Long bloqueto, Long idSequencia, String tipoRelatorio, Long relatorio) {
        return this.fetch(BLOQUETO_ITBI, new Object[]{bloqueto, idSequencia, tipoRelatorio, relatorio});
    }
}

