/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.impl;

import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.ParamGeraDebitoLaudoDTO;
import br.com.elotech.tributos.dto.ValoresLaudoDTO;
import br.com.elotech.tributos.service.ExercicioService;
import br.com.elotech.tributos.service.LaudoAvaliacaoService;
import br.com.elotech.tributos.service.ws.AiseLoginService;
import br.com.elotech.tributos.ws.domain.GeraLaudoAvaliacaoEnvio;
import br.com.elotech.tributos.ws.domain.GeraLaudoAvaliacaoResposta;
import br.com.elotech.tributos.ws.domain.LoginResposta;
import br.com.elotech.tributos.ws.rest.dto.GerarDebitoResponseDTO;
import br.com.elotech.tributos.ws.util.AiseWebServiceHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.springframework.ws.client.core.WebServiceTemplate;

@Service
@Profile(value={"!rest"})
public class AiseLaudoAvaliacaoServiceImpl
implements LaudoAvaliacaoService {
    private static final Logger LOG = LoggerFactory.getLogger(AiseLaudoAvaliacaoServiceImpl.class);
    private final WebServiceTemplate aiseWebServiceTemplate;
    private final AiseLoginService aiseLoginService;
    private final ExercicioService exercicioService;

    public AiseLaudoAvaliacaoServiceImpl(WebServiceTemplate aiseWebServiceTemplate, AiseLoginService aiseLoginService, ExercicioService exercicioService) {
        this.aiseWebServiceTemplate = aiseWebServiceTemplate;
        this.aiseLoginService = aiseLoginService;
        this.exercicioService = exercicioService;
    }

    public GeraLaudoAvaliacaoResposta geraLaudoAvaliacao(Long cadastroGeral) {
        LoginResposta loginResposta = this.aiseLoginService.login();
        GeraLaudoAvaliacaoResposta resposta = (GeraLaudoAvaliacaoResposta)this.aiseWebServiceTemplate.marshalSendAndReceive((Object)new GeraLaudoAvaliacaoEnvio(cadastroGeral, loginResposta.getUserKey(), this.exercicioService.getExercicio()));
        AiseWebServiceHandler.checkDocumento((Long)resposta.getDocumento(), (String)resposta.getRetorno());
        LOG.debug("Resposta da gera\u00e7\u00e3o de laudo de avalia\u00e7\u00e3o {}", (Object)resposta);
        return resposta;
    }

    public ValoresLaudoDTO calcularValorLaudo(List<Long> listCadastroGeral) {
        throw new UnsupportedOperationException("Unsupported Operation.");
    }

    public GerarDebitoResponseDTO gerarDebito(ParamGeraDebitoLaudoDTO param) {
        throw new UnsupportedOperationException("Unsupported Operation.");
    }

    public List<DocumentoDTO> gerarDocumentoLoteLaudoAvaliacao(List<DocumentoDTO> listCadastro) {
        throw new UnsupportedOperationException("Unsupported Operation.");
    }
}

