/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.impl;

import br.com.elotech.core.exception.JsonFormatException;
import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.dto.DebitoHandler;
import br.com.elotech.tributos.service.DebitoCpfService;
import br.com.elotech.tributos.service.ws.AiseLoginService;
import br.com.elotech.tributos.util.LoggerPrototype;
import br.com.elotech.tributos.ws.domain.GetDebitosCpfEnvio;
import br.com.elotech.tributos.ws.domain.GetDebitosCpfResposta;
import br.com.elotech.tributos.ws.domain.LoginResposta;
import br.com.elotech.tributos.ws.rest.dto.DebitoMapper;
import br.com.elotech.tributos.ws.rest.dto.DebitoTransportDTO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.springframework.ws.client.core.WebServiceTemplate;

@Service
@Profile(value={"!rest"})
public class AiseDebitosCpfServiceImpl
implements LoggerPrototype,
DebitoCpfService {
    private final WebServiceTemplate aiseWebServiceTemplate;
    private final ObjectMapper objectMapper;
    private final DebitoMapper debitoMapper;
    private final AiseLoginService aiseLoginService;

    public AiseDebitosCpfServiceImpl(WebServiceTemplate aiseWebServiceTemplate, ObjectMapper objectMapper, DebitoMapper debitoMapper, AiseLoginService aiseLoginService) {
        this.aiseWebServiceTemplate = aiseWebServiceTemplate;
        this.objectMapper = objectMapper;
        this.debitoMapper = debitoMapper;
        this.aiseLoginService = aiseLoginService;
    }

    public List<DebitoDTO> getDebitosAgrupadosCpf(String cpf) {
        LoginResposta loginResposta = this.aiseLoginService.login();
        GetDebitosCpfEnvio wsParams = new GetDebitosCpfEnvio();
        wsParams.setCpf(cpf);
        wsParams.setUserKey(loginResposta.getUserKey());
        List debitos = this.retornoAsObjectCpf((GetDebitosCpfResposta)this.aiseWebServiceTemplate.marshalSendAndReceive((Object)wsParams));
        return DebitoHandler.agrupaContratoParcela((List)debitos);
    }

    public List<DebitoDTO> getDebitosCpf(String cpf) {
        LoginResposta loginResposta = this.aiseLoginService.login();
        GetDebitosCpfEnvio wsParams = new GetDebitosCpfEnvio();
        wsParams.setCpf(cpf);
        wsParams.setUserKey(loginResposta.getUserKey());
        return this.retornoAsObjectCpf((GetDebitosCpfResposta)this.aiseWebServiceTemplate.marshalSendAndReceive((Object)wsParams));
    }

    private List<DebitoDTO> retornoAsObjectCpf(GetDebitosCpfResposta getDebitosCpfResposta) {
        DebitoTransportDTO transport = null;
        try {
            transport = (DebitoTransportDTO)this.objectMapper.readValue(getDebitosCpfResposta.getRetorno(), DebitoTransportDTO.class);
        }
        catch (IOException e) {
            this.logError(e.getLocalizedMessage(), (Throwable)e);
            throw new JsonFormatException("Erro recuperando objeto da mensagem", (Throwable)e);
        }
        return transport.getList().getItems().stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoDTO(arg_0)).collect(Collectors.toList());
    }
}

