/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.impl;

import br.com.elotech.core.exception.JsonFormatException;
import br.com.elotech.tributos.params.CadastroGeralParams;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.DebitoCarneService;
import br.com.elotech.tributos.service.ws.AiseDebitosCarneService;
import br.com.elotech.tributos.service.ws.AiseLoginService;
import br.com.elotech.tributos.util.LoggerPrototype;
import br.com.elotech.tributos.ws.domain.GetDebitosCarneEnvio;
import br.com.elotech.tributos.ws.domain.GetDebitosCarneResposta;
import br.com.elotech.tributos.ws.domain.LoginResposta;
import br.com.elotech.tributos.ws.rest.dto.DebitoCarneDTO;
import br.com.elotech.tributos.ws.rest.dto.DebitoCarneTransportDTO;
import br.com.elotech.tributos.ws.rest.dto.DebitoMapper;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.springframework.ws.client.core.WebServiceTemplate;

@Service
@Profile(value={"!rest"})
public class AiseDebitosCarneServiceImpl
implements LoggerPrototype,
DebitoCarneService,
AiseDebitosCarneService {
    private final WebServiceTemplate aiseWebServiceTemplate;
    private final AiseLoginService aiseLoginService;
    private final ObjectMapper objectMapper;
    private final DebitoMapper debitoMapper;
    private final CadastroGeralService cadastroGeralService;

    public AiseDebitosCarneServiceImpl(WebServiceTemplate aiseWebServiceTemplate, AiseLoginService aiseLoginService, ObjectMapper objectMapper, DebitoMapper debitoMapper, CadastroGeralService cadastroGeralService) {
        this.aiseWebServiceTemplate = aiseWebServiceTemplate;
        this.aiseLoginService = aiseLoginService;
        this.objectMapper = objectMapper;
        this.debitoMapper = debitoMapper;
        this.cadastroGeralService = cadastroGeralService;
    }

    public List<DebitoCarneDTO> getDebitosCarne(CadastroGeralParams params) {
        LoginResposta loginResposta = this.aiseLoginService.login();
        this.cadastroGeralService.validaCadastroGeral(params.getTipoCadastro(), params.getCadastroGeral());
        GetDebitosCarneEnvio wsParams = new GetDebitosCarneEnvio();
        wsParams.setTipoCadastro(params.getTipoCadastro());
        wsParams.setCadastroGeral(params.getCadastroGeral());
        wsParams.setUserKey(loginResposta.getUserKey());
        return this.retornoAsObject((GetDebitosCarneResposta)this.aiseWebServiceTemplate.marshalSendAndReceive((Object)wsParams));
    }

    private List<DebitoCarneDTO> retornoAsObject(GetDebitosCarneResposta debitosCarneResposta) {
        DebitoCarneTransportDTO transport = null;
        try {
            transport = (DebitoCarneTransportDTO)this.objectMapper.readValue(debitosCarneResposta.getRetorno(), DebitoCarneTransportDTO.class);
        }
        catch (IOException e) {
            this.logError(e.getLocalizedMessage(), (Throwable)e);
            throw new JsonFormatException("Erro recuperando objeto da mensagem", (Throwable)e);
        }
        return transport.getList().getItems().stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoCarneDTO(arg_0)).collect(Collectors.toList());
    }
}

