/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.impl;

import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.params.CertidaoParams;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.CertidaoService;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import br.com.elotech.tributos.service.ws.AiseLoginService;
import br.com.elotech.tributos.ws.domain.GeraCertidaoEnvio;
import br.com.elotech.tributos.ws.domain.GeraCertidaoResposta;
import br.com.elotech.tributos.ws.function.CertidaoParamsToGeraCertidaoEnvio;
import br.com.elotech.tributos.ws.util.AiseWebServiceHandler;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.springframework.ws.client.core.WebServiceTemplate;

@Service
@Profile(value={"!rest"})
public class AiseCertidaoServiceImpl
implements CertidaoService {
    private final WebServiceTemplate aiseWebServiceTemplate;
    private final AiseLoginService aiseLoginService;
    private final CadastroGeralService cadastroGeralService;

    public AiseCertidaoServiceImpl(WebServiceTemplate aiseWebServiceTemplate, AiseLoginService aiseLoginService, CadastroGeralService cadastroGeralService) {
        this.aiseWebServiceTemplate = aiseWebServiceTemplate;
        this.aiseLoginService = aiseLoginService;
        this.cadastroGeralService = cadastroGeralService;
    }

    public GeraCertidaoResposta geraCertidao(CertidaoParams params) {
        this.validaCadastroGeral(params);
        CertidaoParamsToGeraCertidaoEnvio toGeraCertidaoEnvio = new CertidaoParamsToGeraCertidaoEnvio();
        GeraCertidaoEnvio wsParams = toGeraCertidaoEnvio.apply(params);
        wsParams.setUserKey(this.aiseLoginService.login().getUserKey());
        GeraCertidaoResposta resposta = (GeraCertidaoResposta)this.aiseWebServiceTemplate.marshalSendAndReceive((Object)wsParams);
        AiseWebServiceHandler.checkDocumento((Long)resposta.getDocumento(), (String)resposta.getRetorno());
        return resposta;
    }

    private void validaCadastroGeral(CertidaoParams params) {
        if (params.getCadastroGeral() != null && !this.cadastroGeralService.exists(TipoCadastro.fromValue((Long)params.getTipoCadastro().longValue()), params.getCadastroGeral()).booleanValue()) {
            throw new CadastroNaoEncontradoException(TipoCadastro.fromValue((Long)params.getTipoCadastro().longValue()), params.getCadastroGeral());
        }
    }
}

