/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.impl;

import br.com.elotech.tributos.params.CertidaoQuitacaoITBIParams;
import br.com.elotech.tributos.service.CertidaoQuitacaoITBIService;
import br.com.elotech.tributos.service.ws.AiseLoginService;
import br.com.elotech.tributos.ws.domain.GeraCertidaoQuitacaoITBIEnvio;
import br.com.elotech.tributos.ws.domain.GeraCertidaoQuitacaoITBIEnvioMapper;
import br.com.elotech.tributos.ws.domain.GeraCertidaoQuitacaoITBIResposta;
import br.com.elotech.tributos.ws.domain.LoginResposta;
import br.com.elotech.tributos.ws.util.AiseWebServiceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.springframework.ws.client.core.WebServiceTemplate;

@Service
@Profile(value={"!rest"})
public class AiseCertidaoQuitacaoITBIServiceImpl
implements CertidaoQuitacaoITBIService {
    private static final Logger LOG = LoggerFactory.getLogger(AiseCertidaoQuitacaoITBIServiceImpl.class);
    private final WebServiceTemplate aiseWebServiceTemplate;
    private final AiseLoginService aiseLoginService;
    private final GeraCertidaoQuitacaoITBIEnvioMapper geraCertidaoQuitacaoITBIEnvioMapper;

    public AiseCertidaoQuitacaoITBIServiceImpl(WebServiceTemplate aiseWebServiceTemplate, AiseLoginService aiseLoginService, GeraCertidaoQuitacaoITBIEnvioMapper geraCertidaoQuitacaoITBIEnvioMapper) {
        this.aiseWebServiceTemplate = aiseWebServiceTemplate;
        this.aiseLoginService = aiseLoginService;
        this.geraCertidaoQuitacaoITBIEnvioMapper = geraCertidaoQuitacaoITBIEnvioMapper;
    }

    public GeraCertidaoQuitacaoITBIResposta geraCertidaoQuitacaoITBI(CertidaoQuitacaoITBIParams params) {
        LoginResposta loginResposta = this.aiseLoginService.login();
        GeraCertidaoQuitacaoITBIEnvio wsParams = this.geraCertidaoQuitacaoITBIEnvioMapper.toGeraCertidaoQuitacaoITBIEnvio(params);
        wsParams.setUserKey(loginResposta.getUserKey());
        GeraCertidaoQuitacaoITBIResposta resposta = (GeraCertidaoQuitacaoITBIResposta)this.aiseWebServiceTemplate.marshalSendAndReceive((Object)wsParams);
        LOG.debug("Resposta da gera\u00e7\u00e3o de Certid\u00e3o de Quita\u00e7\u00e3o {}", (Object)resposta);
        AiseWebServiceHandler.checkDocumento((Long)resposta.getDocumento().longValue(), (String)resposta.getRetorno());
        return resposta;
    }
}

