/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.impl;

import br.com.elotech.tributos.dto.CarneDTO;
import br.com.elotech.tributos.service.CarneService;
import br.com.elotech.tributos.service.ws.AiseLoginService;
import br.com.elotech.tributos.ws.domain.GeraCarneEnvio;
import br.com.elotech.tributos.ws.domain.GeraCarneResposta;
import br.com.elotech.tributos.ws.domain.LoginResposta;
import br.com.elotech.tributos.ws.mapper.AiseWSMapper;
import br.com.elotech.tributos.ws.rest.dto.DebitoCarneDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.springframework.ws.client.core.WebServiceTemplate;

@Service
@Profile(value={"!rest"})
public class AiseCarneServiceImpl
implements CarneService {
    private static final Logger LOG = LoggerFactory.getLogger(AiseCarneServiceImpl.class);
    private final WebServiceTemplate aiseWebServiceTemplate;
    private final AiseLoginService aiseLoginService;
    private final AiseWSMapper aiseWSMapper;

    public AiseCarneServiceImpl(WebServiceTemplate aiseWebServiceTemplate, AiseLoginService aiseLoginService, AiseWSMapper aiseWSMapper) {
        this.aiseWebServiceTemplate = aiseWebServiceTemplate;
        this.aiseLoginService = aiseLoginService;
        this.aiseWSMapper = aiseWSMapper;
    }

    public CarneDTO geraCarne(DebitoCarneDTO debitoCarneDTO) {
        LoginResposta loginResposta = this.aiseLoginService.login();
        LOG.debug("Requisi\u00e7\u00e3o para gerar carne com os dados {}", (Object)debitoCarneDTO);
        GeraCarneEnvio wsParams = this.aiseWSMapper.toEnvio(loginResposta, debitoCarneDTO);
        return this.retornoAsObject((GeraCarneResposta)this.aiseWebServiceTemplate.marshalSendAndReceive((Object)wsParams));
    }

    private CarneDTO retornoAsObject(GeraCarneResposta geraCarneResposta) {
        return new CarneDTO(geraCarneResposta.getRetorno());
    }
}

