/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.impl;

import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.dto.mobile.DebitoBloquetoMobileDTO;
import br.com.elotech.tributos.service.AiseBloquetoService;
import br.com.elotech.tributos.service.ws.AiseLoginService;
import br.com.elotech.tributos.ws.domain.GeraBloquetoEnvio;
import br.com.elotech.tributos.ws.domain.GeraBloquetoResposta;
import br.com.elotech.tributos.ws.domain.LoginResposta;
import br.com.elotech.tributos.ws.mapper.AiseWSMapper;
import br.com.elotech.tributos.ws.rest.dto.BloquetoDTO;
import br.com.elotech.tributos.ws.rest.dto.DebitoItbiDTO;
import java.time.LocalDate;
import java.util.List;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.springframework.ws.client.core.WebServiceTemplate;

@Service
@Profile(value={"!rest"})
public class AiseBloquetoServiceImpl
implements AiseBloquetoService {
    private final AiseLoginService aiseLoginService;
    private final WebServiceTemplate aiseWebServiceTemplate;
    private final AiseWSMapper aiseWSMapper;

    public AiseBloquetoServiceImpl(AiseLoginService aiseLoginService, WebServiceTemplate aiseWebServiceTemplate, AiseWSMapper aiseWSMapper) {
        this.aiseLoginService = aiseLoginService;
        this.aiseWebServiceTemplate = aiseWebServiceTemplate;
        this.aiseWSMapper = aiseWSMapper;
    }

    public BloquetoDTO geraBloqueto(List<DebitoDTO> debitosMarcados) {
        LoginResposta loginResposta = this.aiseLoginService.login();
        return this.getBloquetoInternal(debitosMarcados, loginResposta);
    }

    private BloquetoDTO getBloquetoInternal(List<DebitoDTO> debitosMarcados, LoginResposta loginResposta) {
        GeraBloquetoEnvio wsParams = this.aiseWSMapper.toEnvio(loginResposta, debitosMarcados);
        GeraBloquetoResposta geraBloquetoResposta = (GeraBloquetoResposta)this.aiseWebServiceTemplate.marshalSendAndReceive((Object)wsParams);
        BloquetoDTO bloquetoDTO = new BloquetoDTO();
        bloquetoDTO.setBloqueto(Long.valueOf(geraBloquetoResposta.getRetorno().replaceAll("\\D+", "")));
        return bloquetoDTO;
    }

    public BloquetoDTO geraBloquetoPorListaDebito(List<DebitoBloquetoMobileDTO> debitosMarcados) {
        throw new UnsupportedOperationException("Unsupported Operation.");
    }

    public BloquetoDTO geraBloquetoPorDataPagamento(List<DebitoDTO> debitosMarcados, LocalDate dataPagamento) {
        throw new UnsupportedOperationException("Unsupported Operation.");
    }

    public BloquetoDTO geraBloquetoItbi(DebitoItbiDTO debitoItbi) {
        throw new UnsupportedOperationException("Unsupported Operation.");
    }
}

