/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.mobile;

import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.DebitoCotaUnicaDTO;
import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.dto.GuiaFormaPagamentoReceitaDTO;
import br.com.elotech.tributos.dto.GuiaRecolhimentoFormaPagamentoDTO;
import br.com.elotech.tributos.dto.mobile.DebitoBloquetoMobileDTO;
import br.com.elotech.tributos.repository.DebitoParcelaReceitaRepository;
import br.com.elotech.tributos.repository.GuiaFormaPagamentoReceitaRepository;
import br.com.elotech.tributos.repository.GuiaRecolhimentoFormaPagamentoRepository;
import br.com.elotech.tributos.repository.GuiaRecolhimentoRepository;
import br.com.elotech.tributos.repository.mobile.DebitoMobileRepository;
import br.com.elotech.tributos.service.mobile.DebitoParcelaReceitaDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class DebitoMobileService {
    private final DebitoMobileRepository debitoMobileRepository;
    private final GuiaRecolhimentoRepository guiaRecolhimentoRepository;
    private final GuiaFormaPagamentoReceitaRepository guiaFormaPagamentoReceitaRepository;
    private final GuiaRecolhimentoFormaPagamentoRepository guiaFormaPagamentoRepository;
    private final DebitoParcelaReceitaRepository debitoParcelaReceitaRepository;

    public DebitoMobileService(DebitoMobileRepository debitoMobileRepository, GuiaRecolhimentoRepository guiaRecolhimentoRepository, GuiaFormaPagamentoReceitaRepository guiaFormaPagamentoReceitaRepository, GuiaRecolhimentoFormaPagamentoRepository guiaFormaPagamentoRepository, DebitoParcelaReceitaRepository debitoParcelaReceitaRepository) {
        this.debitoMobileRepository = debitoMobileRepository;
        this.guiaRecolhimentoRepository = guiaRecolhimentoRepository;
        this.guiaFormaPagamentoReceitaRepository = guiaFormaPagamentoReceitaRepository;
        this.debitoParcelaReceitaRepository = debitoParcelaReceitaRepository;
        this.guiaFormaPagamentoRepository = guiaFormaPagamentoRepository;
    }

    public List<DebitoDTO> getDebitoBloquetoPorListaDebito(List<DebitoBloquetoMobileDTO> debitos) {
        ArrayList<DebitoDTO> listDebito = new ArrayList<DebitoDTO>();
        debitos.forEach(debito -> {
            if (debito.geraBoletoPorIdParcelamento()) {
                listDebito.addAll(this.getDebitoBloquetoPorIdParcelamento(debito));
            } else {
                listDebito.addAll(this.getDebitoBloquetoPorIdDebito(debito));
            }
        });
        return listDebito;
    }

    public List<DebitoDTO> getDebitoBloquetoPorIdDebito(DebitoBloquetoMobileDTO debitoBloquetoMobileDTO) {
        DebitoDTO debito = this.debitoMobileRepository.findDebitoPorId(debitoBloquetoMobileDTO.getIdDebito());
        return this.generateDebitoBloqueto(debito, debitoBloquetoMobileDTO.getParcelas());
    }

    public List<DebitoDTO> getDebitoBloquetoPorIdParcelamento(DebitoBloquetoMobileDTO debitoBloquetoMobileDTO) {
        List debitosParcelamento = this.debitoMobileRepository.findDebitoPorIdParcelamento(debitoBloquetoMobileDTO.getIdParcelamento());
        ArrayList<DebitoDTO> debitoBloqueto = new ArrayList<DebitoDTO>();
        debitosParcelamento.forEach(debito -> debitoBloqueto.addAll(this.generateDebitoBloqueto(debito, debitoBloquetoMobileDTO.getParcelas())));
        return debitoBloqueto;
    }

    private List<DebitoDTO> generateDebitoBloqueto(DebitoDTO debito, List<Integer> parcelas) {
        return parcelas.stream().map(m -> {
            DebitoDTO debitoRetorno = new DebitoDTO();
            debitoRetorno.setEntidade(debito.getEntidade());
            debitoRetorno.setExercicio(debito.getExercicio());
            debitoRetorno.setTipoCadastro(debito.getTipoCadastro());
            debitoRetorno.setCadastroGeral(debito.getCadastroGeral());
            debitoRetorno.setGuiaRecolhimento(debito.getGuiaRecolhimento());
            debitoRetorno.setSubDivida(debito.getSubDivida());
            debitoRetorno.setParcela(Long.valueOf(m.longValue()));
            debitoRetorno.setPessoa(debito.getPessoa());
            debitoRetorno.setIdDebito(debito.getIdDebito());
            return debitoRetorno;
        }).collect(Collectors.toList());
    }

    public List<DebitoCotaUnicaDTO> getDebitoCotaUnica(Integer entidade, Integer exercicio, TipoCadastro tipoCadastro, Integer cadastroGeral, LocalDate dataReferencia) {
        List listGuiaRecolhimentoIPTU = this.guiaRecolhimentoRepository.findGuiaRecolhimentoIPTU(entidade, exercicio);
        ArrayList<DebitoCotaUnicaDTO> listDebitoCotaUnica = new ArrayList<DebitoCotaUnicaDTO>();
        listGuiaRecolhimentoIPTU.forEach(guiaIPTU -> {
            GuiaRecolhimentoFormaPagamentoDTO formaPagamentoIPTU = this.getFormaPagamentoIPTUPrioritaria(entidade, exercicio, guiaIPTU.getGuiaRecolhimento(), dataReferencia);
            DebitoDTO debitoDTO = this.debitoMobileRepository.findDebitoCotaUnicaIPTU(entidade, exercicio, tipoCadastro, cadastroGeral, guiaIPTU.getGuiaRecolhimento());
            if (formaPagamentoIPTU != null && debitoDTO != null) {
                List listDebitoParcelaReceita = this.debitoParcelaReceitaRepository.findDebitoParcelaReceita(debitoDTO);
                List listGuiaFormaPagamentoReceita = this.guiaFormaPagamentoReceitaRepository.getGuiaFormaPagamentoReceita(entidade, exercicio, formaPagamentoIPTU.getGuiaRecolhimento(), formaPagamentoIPTU.getFormaPagamento());
                this.calculaValorDescontoDebitoParcelaReceita(listDebitoParcelaReceita, listGuiaFormaPagamentoReceita);
                BigDecimal valorComDesconto = this.getValorTotalComDesconto(listDebitoParcelaReceita);
                BigDecimal valorOriginal = this.getValorTotal(listDebitoParcelaReceita);
                DebitoCotaUnicaDTO debitoCotaUnicaDTO = new DebitoCotaUnicaDTO();
                debitoCotaUnicaDTO.setIdDebito(debitoDTO.getIdDebito());
                debitoCotaUnicaDTO.setTipoCadastro(debitoDTO.getTipoCadastro());
                debitoCotaUnicaDTO.setCadastroGeral(debitoDTO.getCadastroGeral());
                debitoCotaUnicaDTO.setDescricaoVisualizacao(guiaIPTU.getDescricao());
                debitoCotaUnicaDTO.setFormaPagamento(formaPagamentoIPTU.getFormaPagamento());
                debitoCotaUnicaDTO.setVencimento(formaPagamentoIPTU.getVencimento());
                debitoCotaUnicaDTO.setValor(valorComDesconto);
                debitoCotaUnicaDTO.setValorOriginal(valorOriginal);
                debitoCotaUnicaDTO.setPercentualDesconto(this.getPercentualDesconto(listGuiaFormaPagamentoReceita));
                listDebitoCotaUnica.add(debitoCotaUnicaDTO);
            }
        });
        return listDebitoCotaUnica;
    }

    private BigDecimal getPercentualDesconto(List<GuiaFormaPagamentoReceitaDTO> listGuiaFormaPagamentoReceita) {
        List listaDescontos = listGuiaFormaPagamentoReceita.stream().map(GuiaFormaPagamentoReceitaDTO::getDesconto).filter(f -> f.compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        if (!listaDescontos.isEmpty()) {
            return (BigDecimal)listaDescontos.get(0);
        }
        return BigDecimal.ZERO;
    }

    private GuiaRecolhimentoFormaPagamentoDTO getFormaPagamentoIPTUPrioritaria(Integer entidade, Integer exercicio, Integer guiaRecolhimento, LocalDate dataReferencia) {
        List listFormapagamentoIPTU = this.guiaFormaPagamentoRepository.findFormaPagamentoIPTUWeb(entidade, exercicio, guiaRecolhimento, dataReferencia);
        if (!listFormapagamentoIPTU.isEmpty()) {
            return (GuiaRecolhimentoFormaPagamentoDTO)listFormapagamentoIPTU.get(0);
        }
        return null;
    }

    private BigDecimal getValorTotal(List<DebitoParcelaReceitaDTO> listDebitoParcelaReceita) {
        Optional<BigDecimal> valorOriginal = listDebitoParcelaReceita.stream().map(DebitoParcelaReceitaDTO::getValorTotalSemDesconto).reduce((valor1, valor2) -> valor1.add((BigDecimal)valor2));
        if (valorOriginal.isPresent()) {
            return valorOriginal.get();
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getValorTotalComDesconto(List<DebitoParcelaReceitaDTO> listDebitoParcelaReceita) {
        Optional<BigDecimal> valorComDesconto = listDebitoParcelaReceita.stream().map(DebitoParcelaReceitaDTO::getValorTotal).reduce((valor1, valor2) -> valor1.add((BigDecimal)valor2));
        if (valorComDesconto.isPresent()) {
            return valorComDesconto.get();
        }
        return BigDecimal.ZERO;
    }

    private void calculaValorDescontoDebitoParcelaReceita(List<DebitoParcelaReceitaDTO> listDebitoParcelaReceita, List<GuiaFormaPagamentoReceitaDTO> listGuiaFormaPagamentoReceita) {
        listGuiaFormaPagamentoReceita.forEach(receita -> {
            if (receita.possuiDesconto().booleanValue()) {
                listDebitoParcelaReceita.stream().filter(f -> f.getReceita().equals(receita.getReceita())).map(m -> {
                    m.applyDescontoPrincipal(receita.getDesconto());
                    m.applyDescontoJuros(receita.getDescontoJuros());
                    m.applyDescontoMulta(receita.getDescontoMulta());
                    m.applyDescontoCorrecao(receita.getDescontoCorrecao());
                    return m;
                }).collect(Collectors.toList());
            }
        });
    }
}

