/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.tributos.domain.ParametroEntidadeEnum;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.service.ParametroEntidadeService;
import br.com.elotech.tributos.service.ParametroGeralService;
import org.apache.commons.lang.NotImplementedException;
import org.springframework.stereotype.Service;

@Service(value="sequenceCadastroGeralService")
public class SequenceCadastroGeralService {
    private static final String SEQUENCE_CODIGO_SEQ = "S05CODIGOIMOBILIARIO";
    private static final String SEQUENCE_CADASTRO_SEQ = "S05CDSCADASTROIMOBILIARIO";
    private final ParametroGeralService parametroGeralService;
    private final ParametroEntidadeService parametroEntidadeService;

    public SequenceCadastroGeralService(ParametroGeralService parametroGeralService, ParametroEntidadeService parametroEntidadeService) {
        this.parametroGeralService = parametroGeralService;
        this.parametroEntidadeService = parametroEntidadeService;
    }

    public String getExpression(TipoCadastro tipoCadastro) {
        StringBuilder sequenceName = new StringBuilder();
        if (tipoCadastro.isImobiliario().booleanValue()) {
            if (!(this.utilizaSetorImobiliario() || this.informaCadastroManual() || this.codigoImobiliarioSequencial())) {
                sequenceName.append(SEQUENCE_CADASTRO_SEQ);
            } else if (this.codigoImobiliarioSequencial()) {
                sequenceName.append(SEQUENCE_CODIGO_SEQ);
            }
        } else {
            throw new NotImplementedException("N\u00e3o foi implementado o gerenciamento da sequ\u00eancia para este Tipo de Cadastro");
        }
        return sequenceName.toString();
    }

    private boolean utilizaSetorImobiliario() {
        return this.parametroEntidadeService.getParamValueAsBoolean(ParametroEntidadeEnum.UTILIZA_SETOR_IMOBILIARIO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private boolean informaCadastroManual() {
        return this.parametroEntidadeService.getParamValueAsBoolean(ParametroEntidadeEnum.INFORMA_CADASTRO_MANUAL, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private boolean codigoImobiliarioSequencial() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CODIGO_IMOBILIARIO_SEQUENCIAL, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }
}

