/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.ParametroEntidade;
import br.com.elotech.tributos.domain.ParametroEntidadeEnum;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.repository.ParametroEntidadeRepository;
import br.com.elotech.tributos.service.impl.exception.ParametroNaoEncontradoException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ParametroEntidadeService
extends CrudService<ParametroEntidade, Long> {
    private final Logger log = LoggerFactory.getLogger(ParametroEntidadeService.class);
    private final ParametroEntidadeRepository parametroEntidadeRepository;
    private final EntidadeRepository entidadeRepository;

    public ParametroEntidadeService(ParametroEntidadeRepository parametroEntidadeRepository, EntidadeRepository entidadeRepository) {
        this.parametroEntidadeRepository = parametroEntidadeRepository;
        this.entidadeRepository = entidadeRepository;
    }

    public ParametroEntidade findByParametroAndModulo(ParametroEntidadeEnum parametro, String modulo) {
        ParametroEntidade parametroEntidade = this.parametroEntidadeRepository.findByEntidadeAndModuloAndParametro(this.entidadeRepository.findByEntidadeprincipal().getId(), modulo, parametro.getValue());
        this.validaParametro(parametro, parametroEntidade);
        return parametroEntidade;
    }

    public String getParamValueAsString(ParametroEntidadeEnum parametro, String modulo) {
        ParametroEntidade param = this.findByParametroAndModulo(parametro, modulo);
        this.log.info("O valor do p\u00e2rametro " + parametro.getValue() + " \u00e9 " + param);
        return Optional.ofNullable(param).map(p -> p.getValor()).orElse("");
    }

    public Boolean getParamValueAsBoolean(ParametroEntidadeEnum parametro, String modulo) {
        String paramValue = this.getParamValueAsString(parametro, modulo);
        return SimNao.toBoolean((String)paramValue, (Boolean)Boolean.FALSE);
    }

    public Boolean paramsValueAreTrue(List<ParametroEntidadeEnum> parametros, String modulo) {
        return !parametros.stream().filter(param -> this.getParamValueAsBoolean(param, modulo).equals(false)).findFirst().isPresent();
    }

    private void validaParametro(ParametroEntidadeEnum parametro, ParametroEntidade parametroEntidade) {
        if (Objects.isNull(parametroEntidade) && !parametro.possuiValorPadrao().booleanValue()) {
            throw new ParametroNaoEncontradoException(parametro.getDescricao());
        }
    }
}

