/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.mobile.DocumentoMobileDTO;
import br.com.elotech.tributos.repository.CadastroGeralRepository;
import br.com.elotech.tributos.repository.DocumentoRepository;
import br.com.elotech.tributos.repository.projections.DocumentoProjection;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import br.com.elotech.tributos.service.ws.AisePdfService;
import java.time.LocalDate;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DocumentoService {
    private final DocumentoRepository documentoRepository;
    private final CadastroGeralRepository cadastroGeralRepository;
    private final AisePdfService aisePdfService;

    @Autowired
    public DocumentoService(DocumentoRepository documentoRepository, CadastroGeralRepository cadastroGeralRepository, AisePdfService aisePdfService) {
        this.documentoRepository = documentoRepository;
        this.cadastroGeralRepository = cadastroGeralRepository;
        this.aisePdfService = aisePdfService;
    }

    public DocumentoProjection getDTO(String codigoValidacao) {
        return this.documentoRepository.findByCodigoValidacao(codigoValidacao);
    }

    public DocumentoMobileDTO getDocumentoMobileDTO(Long entidade, Long exercicio, Long tipoDocumento, Long documento) {
        Documento documentoEntity = this.documentoRepository.findByEntidadeTributacaoEntidadeIdAndEntidadeTributacaoExercicioAndTipoDocumentoIdAndDocumento(entidade, exercicio, tipoDocumento, documento);
        String urlImpressao = this.aisePdfService.fetchDocumento(documento, Integer.valueOf(tipoDocumento.intValue()), Integer.valueOf(exercicio.intValue()));
        return new DocumentoMobileDTO(documentoEntity, urlImpressao);
    }

    public DocumentoDTO getDocumentoDTO(Long entidade, Long exercicio, Long tipoDocumento, Long documento) {
        Documento documentoEntity = this.documentoRepository.findByEntidadeTributacaoEntidadeIdAndEntidadeTributacaoExercicioAndTipoDocumentoIdAndDocumento(entidade, exercicio, tipoDocumento, documento);
        String urlImpressao = this.aisePdfService.fetchDocumento(documento, Integer.valueOf(tipoDocumento.intValue()), Integer.valueOf(exercicio.intValue()));
        return DocumentoDTO.from((Documento)documentoEntity, (String)urlImpressao);
    }

    public List<DocumentoProjection> getListDocumentoDTO(TipoCadastro tipoCadastro, Long cadastroGeral) {
        CadastroGeral cadastroGeralEntity = (CadastroGeral)this.cadastroGeralRepository.findOneByTipoCadastroAndCadastroGeral(tipoCadastro, cadastroGeral).orElseThrow(() -> new CadastroNaoEncontradoException(tipoCadastro, cadastroGeral));
        return this.documentoRepository.findByCadastroGeral(cadastroGeralEntity, LocalDate.now());
    }
}

