/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.core.utils.OptionsUtils;
import br.com.elotech.tributos.converter.TipoCadastroConverter;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.SituacaoMobiliario;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSituacao;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.domain.mobiliario.RegimeFiscal;
import br.com.elotech.tributos.dto.CadastroGeralAcessoWebDTO;
import br.com.elotech.tributos.repository.CadastroGeralRepository;
import br.com.elotech.tributos.repository.projections.CadastroGeralResponsavelProjection;
import br.com.elotech.tributos.service.RegimeFiscalPeriodoService;
import br.com.elotech.tributos.service.ResponsavelCadastroService;
import br.com.elotech.tributos.service.exception.CadastroExclusaoLogicaException;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CadastroGeralService
extends CrudService<CadastroGeral, Long> {
    private static final OptionsUtils<String> PROPRIO = OptionsUtils.of((Object[])new String[]{"PR", "SR", "RT"});
    private final ResponsavelCadastroService responsavelCadastroService;
    private final CadastroGeralRepository cadastroGeralRepository;
    private final RegimeFiscalPeriodoService regimeFiscalPeriodoService;

    @Autowired
    public CadastroGeralService(CadastroGeralRepository cadastroGeralRepository, ResponsavelCadastroService responsavelCadastroService, RegimeFiscalPeriodoService regimeFiscalPeriodoService) {
        this.cadastroGeralRepository = cadastroGeralRepository;
        this.responsavelCadastroService = responsavelCadastroService;
        this.regimeFiscalPeriodoService = regimeFiscalPeriodoService;
    }

    public List<CadastroGeral> findByPessoaCnpjCpf(String cnpjCpf) {
        return this.cadastroGeralRepository.findByPessoaCnpjCpf(cnpjCpf);
    }

    public Optional<CadastroGeral> findByTipoCadastroAndCadastroGeral(TipoCadastro tipoCadastro, Long cadastroGeral) {
        return this.cadastroGeralRepository.findOneByTipoCadastroAndCadastroGeral(tipoCadastro, cadastroGeral);
    }

    public Optional<CadastroGeralAcessoWebDTO> getCadastro(TipoCadastro tipoCadastro, Long codigoCadastroGeral) {
        Optional cadastroGeral = this.findByTipoCadastroAndCadastroGeral(tipoCadastro, codigoCadastroGeral);
        if (!cadastroGeral.isPresent()) {
            return Optional.empty();
        }
        CadastroGeralAcessoWebDTO cadastroGeralAcessoWebDTO = new CadastroGeralAcessoWebDTO();
        cadastroGeralAcessoWebDTO.setTipoCadastro(tipoCadastro.getValue());
        cadastroGeralAcessoWebDTO.setDescTipoCadastro(tipoCadastro.getDescricao());
        cadastroGeralAcessoWebDTO.setCadastroGeral(codigoCadastroGeral);
        cadastroGeralAcessoWebDTO.setProprio(Boolean.valueOf(false));
        cadastroGeralAcessoWebDTO.setNome(((CadastroGeral)cadastroGeral.get()).getPessoa().getNome());
        cadastroGeralAcessoWebDTO.setCnpjCpf(((CadastroGeral)cadastroGeral.get()).getPessoa().getCnpjCpf());
        cadastroGeralAcessoWebDTO.setEndereco(((CadastroGeral)cadastroGeral.get()).getEnderecoFormatado());
        cadastroGeralAcessoWebDTO.setCidadeUf(((CadastroGeral)cadastroGeral.get()).getCidadeFormatada());
        cadastroGeralAcessoWebDTO.setCep(((CadastroGeral)cadastroGeral.get()).getCep());
        this.preencheDTO(cadastroGeral, cadastroGeralAcessoWebDTO);
        return Optional.of(cadastroGeralAcessoWebDTO);
    }

    public List<CadastroGeralAcessoWebDTO> getCadastrosByCpf(String cpf) {
        ArrayList<CadastroGeralAcessoWebDTO> listCadastroGeralAcessoWeb = new ArrayList<CadastroGeralAcessoWebDTO>();
        List listCadastroGeral = this.responsavelCadastroService.findResponsavelList(cpf);
        for (CadastroGeralResponsavelProjection cadastroGeral : listCadastroGeral) {
            TipoCadastroConverter converter = new TipoCadastroConverter();
            TipoCadastro tipoCadastro = converter.convertToEntityAttribute(cadastroGeral.getTipoCadastro());
            Optional cadastroGeralResponsavel = this.findByTipoCadastroAndCadastroGeral(tipoCadastro, cadastroGeral.getCadastroGeral());
            CadastroGeralAcessoWebDTO cadastroGeralAcessoWebDTO = new CadastroGeralAcessoWebDTO();
            cadastroGeralAcessoWebDTO.setTipoCadastro(cadastroGeral.getTipoCadastro());
            cadastroGeralAcessoWebDTO.setDescTipoCadastro(tipoCadastro.getDescricao());
            cadastroGeralAcessoWebDTO.setCadastroGeral(cadastroGeral.getCadastroGeral());
            cadastroGeralAcessoWebDTO.setProprio(Boolean.valueOf(PROPRIO.contains((Object)cadastroGeral.getTipoVinculo())));
            cadastroGeralAcessoWebDTO.setNome(((CadastroGeral)cadastroGeralResponsavel.get()).getPessoa().getNome());
            cadastroGeralAcessoWebDTO.setCnpjCpf(((CadastroGeral)cadastroGeralResponsavel.get()).getPessoa().getCnpjCpf());
            cadastroGeralAcessoWebDTO.setEndereco(((CadastroGeral)cadastroGeralResponsavel.get()).getEnderecoFormatado());
            cadastroGeralAcessoWebDTO.setCidadeUf(((CadastroGeral)cadastroGeralResponsavel.get()).getCidadeFormatada());
            cadastroGeralAcessoWebDTO.setCep(((CadastroGeral)cadastroGeralResponsavel.get()).getCep());
            this.preencheDTO(cadastroGeralResponsavel, cadastroGeralAcessoWebDTO);
            listCadastroGeralAcessoWeb.add(cadastroGeralAcessoWebDTO);
        }
        return listCadastroGeralAcessoWeb;
    }

    private void preencheDTO(Optional<CadastroGeral> cadastroGeralOptional, CadastroGeralAcessoWebDTO cadastroGeralAcessoWebDTO) {
        CadastroImobiliarioSituacao situacao;
        CadastroGeral cadastroGeral = cadastroGeralOptional.get();
        if (Objects.isNull(cadastroGeral)) {
            return;
        }
        if (cadastroGeral.getTipoCadastro().isMobiliario().booleanValue()) {
            SituacaoMobiliario situacao2;
            CadastroMobiliario cadastroMobiliario = (CadastroMobiliario)cadastroGeralOptional.get();
            RegimeFiscal regimeFiscal = this.regimeFiscalPeriodoService.findRegimeFiscal(cadastroMobiliario.getCadastroGeralISS());
            if (Objects.nonNull(regimeFiscal)) {
                cadastroGeralAcessoWebDTO.setRegimeFiscal(regimeFiscal.getDescricao());
            }
            if (Objects.nonNull(situacao2 = cadastroMobiliario.getSituacaoAtual())) {
                cadastroGeralAcessoWebDTO.setSituacao(situacao2.getId());
                cadastroGeralAcessoWebDTO.setDescSituacao(situacao2.getDescricao());
            }
            cadastroGeralAcessoWebDTO.setNumeroAlvara(cadastroMobiliario.getNumeroAlvara());
            cadastroGeralAcessoWebDTO.setExercicioAlvara(cadastroMobiliario.getExercicioAlvara());
            cadastroGeralAcessoWebDTO.setAtividadePrincipal(cadastroMobiliario.getAtividadePrincipal());
            cadastroGeralAcessoWebDTO.setObservacaoAlvara(cadastroMobiliario.getObservacaoAlvara());
            cadastroGeralAcessoWebDTO.setDataAbertura(cadastroMobiliario.getDataAbertura());
            cadastroGeralAcessoWebDTO.setDataEncerramento(cadastroMobiliario.getDataEncerramento());
            cadastroGeralAcessoWebDTO.setDataValidadeAlvara(cadastroMobiliario.getDataValidadeAlvara());
            cadastroGeralAcessoWebDTO.setDataUltimaFiscalizacao(cadastroMobiliario.getDataUltimaFiscalizacao());
        } else if (cadastroGeral.getTipoCadastro().isImobiliario().booleanValue() && Objects.nonNull(situacao = ((CadastroImobiliario)cadastroGeralOptional.get()).getSituacaoAtual())) {
            cadastroGeralAcessoWebDTO.setSituacao(situacao.getId());
            cadastroGeralAcessoWebDTO.setDescSituacao(situacao.getSituacaoImobiliario().getDescricao());
        }
    }

    public Boolean exists(TipoCadastro tipoCadastro, Long cadastroGeral) {
        return this.cadastroGeralRepository.existsByTipoCadastroAndCadastroGeral(tipoCadastro, cadastroGeral);
    }

    public void validaCadastroGeral(TipoCadastro tipoCadastro, Long cadastroGeral) {
        if (!this.exists(tipoCadastro, cadastroGeral).booleanValue()) {
            throw new CadastroNaoEncontradoException(tipoCadastro, cadastroGeral);
        }
    }

    public void validaCadastroGeralExclusaoLogica(CadastroGeral cadastroGeral) {
        CadastroGeral cadastroGeralSalvo;
        if (!cadastroGeral.isNew() && (cadastroGeralSalvo = (CadastroGeral)this.findOne((Serializable)cadastroGeral.getId())) != null && cadastroGeralSalvo.getExclusaoLogica().booleanValue()) {
            throw new CadastroExclusaoLogicaException(cadastroGeral.getTipoCadastro(), cadastroGeral.getCadastroGeral());
        }
    }
}

