/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.repository.BloquetoRepository;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.service.ExercicioService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BloquetoService
extends ReadOnlyService<Bloqueto, Long> {
    private final EntidadeRepository entidadeRepository;
    private final BloquetoRepository bloquetoRepository;
    private final ExercicioService exercicioService;

    @Autowired
    public BloquetoService(EntidadeRepository entidadeRepository, BloquetoRepository bloquetoRepository, ExercicioService exercicioService) {
        this.entidadeRepository = entidadeRepository;
        this.bloquetoRepository = bloquetoRepository;
        this.exercicioService = exercicioService;
    }

    public Bloqueto findByBloqueto(Long bloqueto) {
        Entidade entidade = this.entidadeRepository.findByEntidadeprincipal();
        Long exercicio = this.exercicioService.getExercicio();
        return this.bloquetoRepository.findByBloqueto(entidade.getId(), exercicio, bloqueto);
    }
}

