/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.dto.ParamGeraDebitoLaudoDTO;
import br.com.elotech.tributos.dto.ValoresLaudoDTO;
import br.com.elotech.tributos.service.LaudoAvaliacaoService;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.ws.domain.GeraLaudoAvaliacaoResposta;
import br.com.elotech.tributos.ws.rest.dto.GerarDebitoResponseDTO;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/laudoavaliacao"})
public class LaudoAvaliacaoResource {
    private final LaudoAvaliacaoService laudoAvaliacaoService;
    private final AisePdfService aisePdfService;

    public LaudoAvaliacaoResource(LaudoAvaliacaoService laudoAvaliacaoService, AisePdfService aisePdfService) {
        this.laudoAvaliacaoService = laudoAvaliacaoService;
        this.aisePdfService = aisePdfService;
    }

    @GetMapping
    public ImpressaoDTO imprimeLaudoAvaliacao(Long cadastroGeral) {
        GeraLaudoAvaliacaoResposta resposta = this.laudoAvaliacaoService.geraLaudoAvaliacao(cadastroGeral);
        return ImpressaoDTO.from((String)this.aisePdfService.fetchDocumento(resposta.getDocumento(), resposta.getTipoDocumento(), resposta.getExercicio()));
    }

    @PostMapping(value={"/documento"})
    public ResponseEntity<List<DocumentoDTO>> geraDocumentoLoteLaudoAvaliacao(@RequestBody List<DocumentoDTO> listCadastro) {
        return ResponseEntity.ok((Object)this.laudoAvaliacaoService.gerarDocumentoLoteLaudoAvaliacao(listCadastro));
    }

    @PostMapping(value={"/valor"})
    public ValoresLaudoDTO calculaValoresLaudos(@RequestBody List<Long> listCadastroGeral) {
        return this.laudoAvaliacaoService.calcularValorLaudo(listCadastroGeral);
    }

    @PostMapping(value={"/debito"})
    public GerarDebitoResponseDTO geraDebito(@RequestBody ParamGeraDebitoLaudoDTO param) {
        return this.laudoAvaliacaoService.gerarDebito(param);
    }
}

