/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.repository.IntegracaoItbiRepository;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/integracao/itbi"})
public class IntegracaoItbiResource {
    private final IntegracaoItbiRepository repository;

    public IntegracaoItbiResource(IntegracaoItbiRepository repository) {
        this.repository = repository;
    }

    @GetMapping
    public ResponseEntity<Map<String, Object>> getPackage(@RequestParam(value="since") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) Optional<LocalDate> since) {
        List cadastros = this.repository.findAllCadastroImobiliario(since);
        List proprietarios = this.repository.findAllCadastroImobiliarioProprietario(since);
        Map<Object, List<Map>> groupedByCadastro = proprietarios.stream().collect(Collectors.groupingBy(item -> item.get("cadastroImobiliario")));
        cadastros.forEach(cadastro -> cadastro.put("proprietarios", groupedByCadastro.get(cadastro.get("id"))));
        TreeMap<String, List> result = new TreeMap<String, List>();
        result.put("tipoitbi", this.repository.findAllTipoItbi());
        result.put("tiposegmento", this.repository.findAllTipoSegmento());
        result.put("tipovinculo", this.repository.findAllTipoVinculo());
        result.put("cadastroimobiliario", cadastros);
        return ResponseEntity.ok(result);
    }
}

