/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.mobile;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.DebitoDTO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class DebitoMobileRepository {
    private static final String COLUMN_IDPARCELAMENTO = "idparcelamento";
    private static final String COLUMN_PESSOA = "pessoa";
    private static final String COLUMN_SUBDIVIDA = "subdivida";
    private static final String COLUMN_GUIARECOLHIMENTO = "guiarecolhimento";
    private static final String COLUMN_CADASTROGERAL = "cadastrogeral";
    private static final String COLUMN_TIPOCADASTRO = "tipocadastro";
    private static final String COLUMN_EXERCICIO = "exercicio";
    private static final String COLUMN_ENTIDADE = "entidade";
    private static final String COLUMN_IDDEBITO = "iddebito";
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private static final String SQL_IDDEBITO = "br/com/elotech/tributos/repository/mobile/findDebitoPorId.sql";
    private static final String SQL_IDPARCELAMENTO = "br/com/elotech/tributos/repository/mobile/findDebitoPorIdParcelamento.sql";
    private static final String SQL_DEBITOIPTU = "br/com/elotech/tributos/repository/mobile/findDebitoIPTU.sql";

    public DebitoDTO findDebitoPorId(Long idDebito) {
        String sql = FileUtils.readResourceAsString((String)SQL_IDDEBITO);
        return (DebitoDTO)this.jdbcTemplate.queryForObject(sql, new Object[]{idDebito}, (rs, rowNum) -> {
            DebitoDTO debito = new DebitoDTO();
            debito.setIdDebito(Long.valueOf(rs.getLong(COLUMN_IDDEBITO)));
            debito.setEntidade(Integer.valueOf(rs.getInt(COLUMN_ENTIDADE)));
            debito.setExercicio(Integer.valueOf(rs.getInt(COLUMN_EXERCICIO)));
            debito.setTipoCadastro(Integer.valueOf(rs.getInt(COLUMN_TIPOCADASTRO)));
            debito.setCadastroGeral(Integer.valueOf(rs.getInt(COLUMN_CADASTROGERAL)));
            debito.setGuiaRecolhimento(Integer.valueOf(rs.getInt(COLUMN_GUIARECOLHIMENTO)));
            debito.setSubDivida(Integer.valueOf(rs.getInt(COLUMN_SUBDIVIDA)));
            debito.setPessoa(Integer.valueOf(rs.getInt(COLUMN_PESSOA)));
            return debito;
        });
    }

    public List<DebitoDTO> findDebitoPorIdParcelamento(Long idParcelamento) {
        String sql = FileUtils.readResourceAsString((String)SQL_IDPARCELAMENTO);
        return this.jdbcTemplate.query(sql, new Object[]{idParcelamento}, (rs, rowNum) -> {
            DebitoDTO debito = new DebitoDTO();
            debito.setIdDebito(Long.valueOf(rs.getLong(COLUMN_IDDEBITO)));
            debito.setEntidade(Integer.valueOf(rs.getInt(COLUMN_ENTIDADE)));
            debito.setExercicio(Integer.valueOf(rs.getInt(COLUMN_EXERCICIO)));
            debito.setTipoCadastro(Integer.valueOf(rs.getInt(COLUMN_TIPOCADASTRO)));
            debito.setCadastroGeral(Integer.valueOf(rs.getInt(COLUMN_CADASTROGERAL)));
            debito.setGuiaRecolhimento(Integer.valueOf(rs.getInt(COLUMN_GUIARECOLHIMENTO)));
            debito.setSubDivida(Integer.valueOf(rs.getInt(COLUMN_SUBDIVIDA)));
            debito.setPessoa(Integer.valueOf(rs.getInt(COLUMN_PESSOA)));
            debito.setIdParcelamento(Long.valueOf(rs.getLong(COLUMN_IDPARCELAMENTO)));
            return debito;
        });
    }

    public DebitoDTO findDebitoCotaUnicaIPTU(Integer entidade, Integer exercicio, TipoCadastro tipoCadastro, Integer cadastroGeral, Integer guiaRecolhimento) {
        String sql = FileUtils.readResourceAsString((String)SQL_DEBITOIPTU);
        try {
            return (DebitoDTO)this.jdbcTemplate.queryForObject(sql, new Object[]{entidade, exercicio, tipoCadastro.getValue(), cadastroGeral, guiaRecolhimento}, (rs, rowNum) -> {
                DebitoDTO debito = new DebitoDTO();
                debito.setIdDebito(Long.valueOf(rs.getLong(COLUMN_IDDEBITO)));
                debito.setEntidade(Integer.valueOf(rs.getInt(COLUMN_ENTIDADE)));
                debito.setExercicio(Integer.valueOf(rs.getInt(COLUMN_EXERCICIO)));
                debito.setTipoCadastro(Integer.valueOf(rs.getInt(COLUMN_TIPOCADASTRO)));
                debito.setCadastroGeral(Integer.valueOf(rs.getInt(COLUMN_CADASTROGERAL)));
                debito.setGuiaRecolhimento(Integer.valueOf(rs.getInt(COLUMN_GUIARECOLHIMENTO)));
                debito.setSubDivida(Integer.valueOf(rs.getInt(COLUMN_SUBDIVIDA)));
                return debito;
            });
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }
}

