/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.utils.FileUtils;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.EmptySqlParameterSource;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class IntegracaoItbiRepository {
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public IntegracaoItbiRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<Map<String, Object>> findAllTipoItbi() {
        EmptySqlParameterSource parameterSource = new EmptySqlParameterSource();
        return this.jdbcTemplate.queryForList("SELECT IDTIPOITBI AS \"codigo\", descricao as \"descricao\" FROM TRIBTIPOITBI ORDER BY IDTIPOITBI", (SqlParameterSource)parameterSource);
    }

    public List<Map<String, Object>> findAllTipoVinculo() {
        EmptySqlParameterSource parameterSource = new EmptySqlParameterSource();
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/itbi-vinculo.sql"));
        return this.jdbcTemplate.queryForList(sql.toString(), (SqlParameterSource)parameterSource);
    }

    public List<Map<String, Object>> findAllCadastroImobiliario(Optional<LocalDate> since) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/itbi-cadastroimobiliario.sql"));
        if (since.isPresent()) {
            sql.append(" AND ( ").append("(CG.DATAINCLUSAO >= :DATABASE) OR ").append("(CG.DATAALTERACAO >= :DATABASE) OR ").append("(CG.DATAEXCLUSAOLOGICA >= :DATABASE) OR ").append("(CG.DATARESTAURACAOLOGICA >= :DATABASE) ").append(" ) ");
            parameterSource.addValue("DATABASE", (Object)Date.valueOf(since.get()), 91);
        } else {
            sql.append(" AND CG.EXCLUSAOLOGICA = 'N' ");
        }
        sql.append(" ORDER BY CG.IDKEY ");
        return this.jdbcTemplate.queryForList(sql.toString(), (SqlParameterSource)parameterSource);
    }

    public List<Map<String, Object>> findAllCadastroImobiliarioProprietario(Optional<LocalDate> since) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/itbi-proprietario.sql"));
        if (since.isPresent()) {
            sql.append(" AND ( ").append("(CG.DATAINCLUSAO >= :DATABASE) OR ").append("(CG.DATAALTERACAO >= :DATABASE) OR ").append("(CG.DATAEXCLUSAOLOGICA >= :DATABASE) OR ").append("(CG.DATARESTAURACAOLOGICA >= :DATABASE) ").append(" ) ");
            parameterSource.addValue("DATABASE", (Object)Date.valueOf(since.get()), 91);
        } else {
            sql.append(" AND CG.EXCLUSAOLOGICA = 'N' ");
        }
        sql.append(" ORDER BY CG.IDKEY ");
        return this.jdbcTemplate.query(sql.toString(), (SqlParameterSource)parameterSource, (RowMapper)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<Map<String, Object>> findAllTipoSegmento() {
        EmptySqlParameterSource parameterSource = new EmptySqlParameterSource();
        return this.jdbcTemplate.queryForList("SELECT SEG.TIPOSEGMENTO AS \"id\", SEG.DESCRICAO as \"descricao\" FROM TRIBTIPOSEGMENTO SEG ORDER BY SEG.TIPOSEGMENTO", (SqlParameterSource)parameterSource);
    }
}

