/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.mobile;

import br.com.elotech.tributos.dto.mobile.DebitoMobileDTO;
import br.com.elotech.tributos.dto.mobile.EnderecoMobileDTO;
import java.util.ArrayList;
import java.util.List;

public class PropriedadeMobileDTO {
    private Integer tipoCadastro;
    private Long cadastroGeral;
    private String nome;
    private String cpfCnpj;
    private EnderecoMobileDTO endereco;
    private EnderecoMobileDTO enderecoCorrespondencia;
    private Boolean possuiCotaUnica;
    private List<DebitoMobileDTO> debitos = new ArrayList();

    public int hashCode() {
        int prime = 31;
        int cadastroGeralHashCode = 0;
        if (this.cadastroGeral != null) {
            cadastroGeralHashCode = this.cadastroGeral.hashCode();
        }
        int cpfCnpjHasCode = 0;
        if (this.cpfCnpj != null) {
            cpfCnpjHasCode = this.cpfCnpj.hashCode();
        }
        int tipoCadastroHashCode = 0;
        if (this.tipoCadastro != null) {
            tipoCadastroHashCode = this.tipoCadastro.hashCode();
        }
        int result = 1;
        result = 31 * result + cadastroGeralHashCode;
        result = 31 * result + cpfCnpjHasCode;
        result = 31 * result + tipoCadastroHashCode;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropriedadeMobileDTO other = (PropriedadeMobileDTO)obj;
        return this.cadastroGeralEquals(other) && this.tipoCadastroEquals(other) && this.cpfCnpjEquals(other);
    }

    private boolean cadastroGeralEquals(PropriedadeMobileDTO other) {
        return !(this.cadastroGeral == null ? other.cadastroGeral != null : !this.cadastroGeral.equals(other.cadastroGeral));
    }

    private boolean tipoCadastroEquals(PropriedadeMobileDTO other) {
        return !(this.tipoCadastro == null ? other.tipoCadastro != null : !this.tipoCadastro.equals(other.tipoCadastro));
    }

    private boolean cpfCnpjEquals(PropriedadeMobileDTO other) {
        return !(this.cpfCnpj == null ? other.cpfCnpj != null : !this.cpfCnpj.equals(other.cpfCnpj));
    }

    public void addAllDebitoMobileDTO(List<DebitoMobileDTO> novosDebitos) {
        novosDebitos.forEach(novoDebito -> {
            Integer indexDebito = this.debitos.indexOf(novoDebito);
            if (indexDebito >= 0) {
                ((DebitoMobileDTO)this.debitos.get(indexDebito)).addAllParcelaMobileDTO(novoDebito.getParcelas());
            } else {
                this.debitos.add(novoDebito);
            }
        });
    }

    public EnderecoMobileDTO getEnderecoCorrespondencia() {
        return this.enderecoCorrespondencia;
    }

    public List<DebitoMobileDTO> getDebitos() {
        return this.debitos;
    }

    public void setDebitos(List<DebitoMobileDTO> debitos) {
        this.debitos = debitos;
    }

    public void setEnderecoCorrespondencia(EnderecoMobileDTO enderecoCorrespondencia) {
        this.enderecoCorrespondencia = enderecoCorrespondencia;
    }

    public EnderecoMobileDTO getEndereco() {
        return this.endereco;
    }

    public Boolean getPossuiCotaUnica() {
        return this.possuiCotaUnica;
    }

    public void setPossuiCotaUnica(Boolean possuiCotaUnica) {
        this.possuiCotaUnica = possuiCotaUnica;
    }

    public void setEndereco(EnderecoMobileDTO endereco) {
        this.endereco = endereco;
    }

    public Integer getTipoCadastro() {
        return this.tipoCadastro;
    }

    public void setTipoCadastro(Integer tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }
}

