/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.mobiliario;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.mobiliario.RegimeFiscal;
import br.com.elotech.tributos.dto.RegimeFiscalPeriodoDTO;
import java.time.LocalDate;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.envers.Audited;

@Entity
@Table(name="TRIBREGIMEFISCALPERIODO")
@Audited
public class RegimeFiscalPeriodo
implements EloEntity<Long> {
    @Id
    @Column(name="idRegimeFiscalPeriodo")
    @EloSequence(sequenceName="S05IDREGIMEFISCALPERIODO", applyOnMerge=true)
    private Long id;
    @ManyToOne
    @JoinColumn(name="idRegimeFiscal", referencedColumnName="idRegimeFiscal")
    private RegimeFiscal regimeFiscal;
    private Long controlePrefeitura;
    @Column(name="inicio")
    private LocalDate dataInicial;
    @Column(name="final")
    private LocalDate dataFinal;
    @Column(length=20)
    @Caption(value="Processo")
    private String processo;
    private Long status;
    @Column(name="idcadastro")
    private Long cadastroGeralISS;
    @Column(name="numero_opcao")
    private Long numeroOpcao;

    public Boolean isActual() {
        if (this.dataFinal == null) {
            return true;
        }
        if (this.dataFinal.isAfter(LocalDate.now())) {
            return true;
        }
        return false;
    }

    public static RegimeFiscalPeriodo set(RegimeFiscalPeriodoDTO dto) {
        RegimeFiscalPeriodo regime = new RegimeFiscalPeriodo();
        Optional.ofNullable(dto.getControlePrefeitura()).ifPresent(arg_0 -> regime.setControlePrefeitura(arg_0));
        Optional.ofNullable(dto.getDataInicio()).ifPresent(arg_0 -> regime.setDataInicial(arg_0));
        Optional.ofNullable(dto.getDataFim()).ifPresent(arg_0 -> regime.setDataFinal(arg_0));
        Optional.ofNullable(dto.getNumeroOpcao()).ifPresent(arg_0 -> regime.setNumeroOpcao(arg_0));
        Optional.ofNullable(dto.getProcesso()).ifPresent(arg_0 -> regime.setProcesso(arg_0));
        Optional.ofNullable(dto.getStatus()).ifPresent(arg_0 -> regime.setStatus(arg_0));
        return regime;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public RegimeFiscal getRegimeFiscal() {
        return this.regimeFiscal;
    }

    @Generated
    public Long getControlePrefeitura() {
        return this.controlePrefeitura;
    }

    @Generated
    public LocalDate getDataInicial() {
        return this.dataInicial;
    }

    @Generated
    public LocalDate getDataFinal() {
        return this.dataFinal;
    }

    @Generated
    public String getProcesso() {
        return this.processo;
    }

    @Generated
    public Long getStatus() {
        return this.status;
    }

    @Generated
    public Long getCadastroGeralISS() {
        return this.cadastroGeralISS;
    }

    @Generated
    public Long getNumeroOpcao() {
        return this.numeroOpcao;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setRegimeFiscal(RegimeFiscal regimeFiscal) {
        this.regimeFiscal = regimeFiscal;
    }

    @Generated
    public void setControlePrefeitura(Long controlePrefeitura) {
        this.controlePrefeitura = controlePrefeitura;
    }

    @Generated
    public void setDataInicial(LocalDate dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Generated
    public void setDataFinal(LocalDate dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Generated
    public void setProcesso(String processo) {
        this.processo = processo;
    }

    @Generated
    public void setStatus(Long status) {
        this.status = status;
    }

    @Generated
    public void setCadastroGeralISS(Long cadastroGeralISS) {
        this.cadastroGeralISS = cadastroGeralISS;
    }

    @Generated
    public void setNumeroOpcao(Long numeroOpcao) {
        this.numeroOpcao = numeroOpcao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegimeFiscalPeriodo)) {
            return false;
        }
        RegimeFiscalPeriodo other = (RegimeFiscalPeriodo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RegimeFiscalPeriodo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RegimeFiscalPeriodo(id=" + this.getId() + ", regimeFiscal=" + this.getRegimeFiscal() + ", controlePrefeitura=" + this.getControlePrefeitura() + ", dataInicial=" + this.getDataInicial() + ", dataFinal=" + this.getDataFinal() + ", processo=" + this.getProcesso() + ", status=" + this.getStatus() + ", cadastroGeralISS=" + this.getCadastroGeralISS() + ", numeroOpcao=" + this.getNumeroOpcao() + ")";
    }
}

