/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.mobiliario;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.Cnae;
import br.com.elotech.tributos.dto.CadastroMobiliarioCnaeDTO;
import java.time.LocalDate;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="TRIBMOBILIARIOCNAE")
public class CadastroMobiliarioCnae
implements EloEntity<Long> {
    @Id
    @Column(name="idkey")
    @GeneratedValue(generator="SEQ_MOBILIARIOCNAE", strategy=GenerationType.SEQUENCE)
    @SequenceGenerator(name="SEQ_MOBILIARIOCNAE", sequenceName="S_TRIBMOBILIARIOCNAE_ID")
    private Long id;
    @ManyToOne
    @JoinColumn(name="cnae", referencedColumnName="cnae")
    private Cnae cnae;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Principal")
    private Boolean cnaePrincipal = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Gerar Lan\u00e7amento")
    private Boolean gerarLancamento = Boolean.TRUE;
    private LocalDate dataTerminoAtividade;
    private LocalDate dataInicioAtividade;
    private LocalDate dataInicio;
    private LocalDate dataFim;

    public Long getId() {
        return this.id;
    }

    public Cnae getCnae() {
        return this.cnae;
    }

    public Boolean getCnaePrincipal() {
        return this.cnaePrincipal;
    }

    public Boolean getGerarLancamento() {
        return this.gerarLancamento;
    }

    public LocalDate getDataTerminoAtividade() {
        return this.dataTerminoAtividade;
    }

    public LocalDate getDataInicioAtividade() {
        return this.dataInicioAtividade;
    }

    public LocalDate getDataInicio() {
        return this.dataInicio;
    }

    public LocalDate getDataFim() {
        return this.dataFim;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCnae(Cnae cnae) {
        this.cnae = cnae;
    }

    public void setCnaePrincipal(Boolean cnaePrincipal) {
        this.cnaePrincipal = cnaePrincipal;
    }

    public void setGerarLancamento(Boolean gerarLancamento) {
        this.gerarLancamento = gerarLancamento;
    }

    public void setDataTerminoAtividade(LocalDate dataTerminoAtividade) {
        this.dataTerminoAtividade = dataTerminoAtividade;
    }

    public void setDataInicioAtividade(LocalDate dataInicioAtividade) {
        this.dataInicioAtividade = dataInicioAtividade;
    }

    public void setDataInicio(LocalDate dataInicio) {
        this.dataInicio = dataInicio;
    }

    public void setDataFim(LocalDate dataFim) {
        this.dataFim = dataFim;
    }

    public static CadastroMobiliarioCnae set(CadastroMobiliarioCnaeDTO dto) {
        CadastroMobiliarioCnae cnae = new CadastroMobiliarioCnae();
        Optional.ofNullable(dto.getCnaePrincipal()).ifPresent(arg_0 -> cnae.setCnaePrincipal(arg_0));
        Optional.ofNullable(dto.getDataInicio()).ifPresent(arg_0 -> cnae.setDataInicio(arg_0));
        Optional.ofNullable(dto.getDataFim()).ifPresent(arg_0 -> cnae.setDataFim(arg_0));
        Optional.ofNullable(dto.getGeraLancamento()).ifPresent(arg_0 -> cnae.setGerarLancamento(arg_0));
        return cnae;
    }

    @Generated
    public String toString() {
        return "CadastroMobiliarioCnae(id=" + this.getId() + ", cnae=" + this.getCnae() + ", cnaePrincipal=" + this.getCnaePrincipal() + ", gerarLancamento=" + this.getGerarLancamento() + ", dataTerminoAtividade=" + this.getDataTerminoAtividade() + ", dataInicioAtividade=" + this.getDataInicioAtividade() + ", dataInicio=" + this.getDataInicio() + ", dataFim=" + this.getDataFim() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroMobiliarioCnae)) {
            return false;
        }
        CadastroMobiliarioCnae other = (CadastroMobiliarioCnae)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroMobiliarioCnae;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

