/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.Distrito;
import br.com.elotech.tributos.domain.SetorQuadra;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="tribsetor")
@Cacheable
public class Setor
implements EloEntity<Long> {
    @Id
    @Column(name="idkey")
    @EloSequence(sequenceName="S_TRIBSETOR_ID")
    private Long id;
    @ManyToOne
    @JoinColumn(name="distrito")
    @NotNull
    private Distrito distrito;
    @Length(max=15)
    @Column(name="setor")
    private String setor;
    @Length(max=30)
    private String apelido;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBSETOR_IDKEY", updatable=false, nullable=false)
    @Caption(value="Quadras")
    private final List<SetorQuadra> quadras = new ArrayList();

    public Setor() {
    }

    public Setor(Long id) {
        this.id = id;
    }

    public Setor withId(Long setor) {
        this.setId(setor);
        return this;
    }

    public String getApelido() {
        return this.apelido;
    }

    public void setApelido(String apelido) {
        this.apelido = apelido;
    }

    public List<SetorQuadra> getQuadras() {
        return this.quadras;
    }

    public Long getId() {
        return this.id;
    }

    public Distrito getDistrito() {
        return this.distrito;
    }

    public String getSetor() {
        return this.setor;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setDistrito(Distrito distrito) {
        this.distrito = distrito;
    }

    public void setSetor(String setor) {
        this.setor = setor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Setor)) {
            return false;
        }
        Setor other = (Setor)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Setor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

