/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.common.dto.RegistroDTO;
import br.com.elotech.core.crypto.EloCrypto;
import br.com.elotech.core.domain.support.EloEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity(name="Registro")
@Table
public class Registro
implements EloEntity<Long> {
    public static final String MODULO_TRIBUTACAO = "5";
    public static final String MODULO_ISS = "26";
    public static final String MODULO_TRIBUTOS_WEB = "26";
    @Id
    @Column(name="idkey")
    @EloSequence(sequenceName="S_REGISTRO_ID")
    private Long id;
    @Column(length=2)
    private String modulo;
    @Length(max=100)
    private String nome;
    private LocalDate validade;
    @Column(name="DATALIBERACAO")
    private LocalDate dataLiberacao;
    @Column(length=1)
    private String situacao;
    private Long entidade;
    @Column(name="QTDENTIDADES")
    private Long qtdEntidades;
    @Length(max=10)
    private String codigo;
    @Length(max=30)
    private String senha;
    @Column(length=400)
    private String hash;

    public boolean isValid() {
        if (this.hash == null) {
            return false;
        }
        return this.getCalculatedHash().equals(EloCrypto.decifra((String)this.hash));
    }

    @JsonIgnore
    public String getCalculatedHash() {
        return RegistroDTO.getCalculatedHashOld((LocalDate)this.getValidade(), (LocalDate)this.dataLiberacao, (String)this.getModulo(), (String)this.getNome(), (String)this.codigo, (String)this.senha);
    }

    public LocalDate getDataLiberacao() {
        return this.dataLiberacao;
    }

    public String getSituacao() {
        return this.situacao;
    }

    public Long getEntidade() {
        return this.entidade;
    }

    public Long getQtdEntidades() {
        return this.qtdEntidades;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getSenha() {
        return this.senha;
    }

    public String getHash() {
        return this.hash;
    }

    public void setDataLiberacao(LocalDate dataLiberacao) {
        this.dataLiberacao = dataLiberacao;
    }

    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    public void setQtdEntidades(Long qtdEntidades) {
        this.qtdEntidades = qtdEntidades;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public Long getId() {
        return this.id;
    }

    public String getModulo() {
        return this.modulo;
    }

    public String getNome() {
        return this.nome;
    }

    public LocalDate getValidade() {
        return this.validade;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setModulo(String modulo) {
        this.modulo = modulo;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setValidade(LocalDate validade) {
        this.validade = validade;
    }

    @Generated
    public String toString() {
        return "Registro(id=" + this.getId() + ", modulo=" + this.getModulo() + ", nome=" + this.getNome() + ", validade=" + this.getValidade() + ", dataLiberacao=" + this.getDataLiberacao() + ", situacao=" + this.getSituacao() + ", entidade=" + this.getEntidade() + ", qtdEntidades=" + this.getQtdEntidades() + ", codigo=" + this.getCodigo() + ", senha=" + this.getSenha() + ", hash=" + this.getHash() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Registro)) {
            return false;
        }
        Registro other = (Registro)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$modulo = this.getModulo();
        String other$modulo = other.getModulo();
        if (this$modulo == null ? other$modulo != null : !this$modulo.equals(other$modulo)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        LocalDate this$validade = this.getValidade();
        LocalDate other$validade = other.getValidade();
        if (this$validade == null ? other$validade != null : !((Object)this$validade).equals(other$validade)) {
            return false;
        }
        LocalDate this$dataLiberacao = this.getDataLiberacao();
        LocalDate other$dataLiberacao = other.getDataLiberacao();
        if (this$dataLiberacao == null ? other$dataLiberacao != null : !((Object)this$dataLiberacao).equals(other$dataLiberacao)) {
            return false;
        }
        String this$situacao = this.getSituacao();
        String other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$qtdEntidades = this.getQtdEntidades();
        Long other$qtdEntidades = other.getQtdEntidades();
        if (this$qtdEntidades == null ? other$qtdEntidades != null : !((Object)this$qtdEntidades).equals(other$qtdEntidades)) {
            return false;
        }
        String this$codigo = this.getCodigo();
        String other$codigo = other.getCodigo();
        if (this$codigo == null ? other$codigo != null : !this$codigo.equals(other$codigo)) {
            return false;
        }
        String this$senha = this.getSenha();
        String other$senha = other.getSenha();
        if (this$senha == null ? other$senha != null : !this$senha.equals(other$senha)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        return !(this$hash == null ? other$hash != null : !this$hash.equals(other$hash));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Registro;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $modulo = this.getModulo();
        result = result * 59 + ($modulo == null ? 43 : $modulo.hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        LocalDate $validade = this.getValidade();
        result = result * 59 + ($validade == null ? 43 : ((Object)$validade).hashCode());
        LocalDate $dataLiberacao = this.getDataLiberacao();
        result = result * 59 + ($dataLiberacao == null ? 43 : ((Object)$dataLiberacao).hashCode());
        String $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $qtdEntidades = this.getQtdEntidades();
        result = result * 59 + ($qtdEntidades == null ? 43 : ((Object)$qtdEntidades).hashCode());
        String $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : $codigo.hashCode());
        String $senha = this.getSenha();
        result = result * 59 + ($senha == null ? 43 : $senha.hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        return result;
    }
}

