/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.ModeloGrupo;
import br.com.elotech.tributos.domain.TipoModelo;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Table(name="TRIBMODELO")
@Audited
public class Modelo
implements EloEntity<Long> {
    @Id
    @EloSequence(sequenceName="s05Modelo")
    @Caption(value="Modelo")
    @Column(name="MODELO")
    private Long id;
    @NotEmpty
    @Length(max=50)
    @Caption(value="Descri\u00e7\u00e3o")
    private String descricao;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Exibe Modelo de Campo")
    private Boolean exibeModeloCampo = Boolean.FALSE;
    @ManyToOne
    @JoinColumn
    @NotAudited
    private TipoModelo tipoModelo;
    @Caption(value="Data Altera\u00e7\u00e3o")
    private LocalDate dataAlteracao;
    @Length(max=20)
    @Caption(value="Hora Altera\u00e7\u00e3o")
    private String horaAlteracao;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="modelo", updatable=false, nullable=false)
    @AuditJoinTable(name="TRIBMODELOGRUPO_MODELO_AUD")
    @Caption(value="Modelo Grupo")
    private final List<ModeloGrupo> modeloGrupos = new ArrayList();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public Boolean getExibeModeloCampo() {
        return this.exibeModeloCampo;
    }

    public void setExibeModeloCampo(Boolean exibeModeloCampo) {
        this.exibeModeloCampo = exibeModeloCampo;
    }

    public TipoModelo getTipoModelo() {
        return this.tipoModelo;
    }

    public void setTipoModelo(TipoModelo tipoModelo) {
        this.tipoModelo = tipoModelo;
    }

    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    public String getHoraAlteracao() {
        return this.horaAlteracao;
    }

    public void setHoraAlteracao(String horaAlteracao) {
        this.horaAlteracao = horaAlteracao;
    }

    public List<ModeloGrupo> getModelosgrupo() {
        return this.modeloGrupos;
    }

    @Generated
    public String toString() {
        return "Modelo(id=" + this.getId() + ", descricao=" + this.getDescricao() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Modelo)) {
            return false;
        }
        Modelo other = (Modelo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Modelo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

