/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.config;

import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.cache.ehcache.EhCacheManagerFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.Scope;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@Configuration
@EnableCaching
public class CacheConfiguration {
    @Bean(name={"cacheManager"})
    @Scope(value="prototype")
    @Profile(value={"test"})
    public CacheManager getCacheManager() {
        return new EhCacheCacheManager(this.ehCacheManager().getObject());
    }

    @Bean
    @Scope(value="prototype")
    @Profile(value={"test"})
    public EhCacheManagerFactoryBean ehCacheManager() {
        EhCacheManagerFactoryBean ehCacheManagerBean = new EhCacheManagerFactoryBean();
        ehCacheManagerBean.setConfigLocation((Resource)new ClassPathResource("ehcache.xml"));
        ehCacheManagerBean.setShared(true);
        return ehCacheManagerBean;
    }
}

