/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.api.register.proxy.discovery;

import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.netflix.zuul.filters.RefreshableRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.SimpleRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;

public class EmbeddedRouteLocator
extends SimpleRouteLocator
implements RefreshableRouteLocator {
    @Generated
    private static final Log log = LogFactory.getLog(EmbeddedRouteLocator.class);
    private final PeerAwareInstanceRegistry registry;
    private final Map<String, ZuulProperties.ZuulRoute> routesMap = new LinkedHashMap();
    private final Map<String, ZuulProperties.ZuulRoute> routesMapStatic = new LinkedHashMap();

    public EmbeddedRouteLocator(String servletPath, ZuulProperties properties, PeerAwareInstanceRegistry registry) {
        super(servletPath, properties);
        this.registry = registry;
    }

    protected Map<String, ZuulProperties.ZuulRoute> locateRoutes() {
        log.info((Object)("LocateRoutes  to " + this.routesMap));
        return this.routesMap;
    }

    private List<String> getServices() {
        Applications applications = this.registry.getApplications();
        List registered = applications.getRegisteredApplications();
        ArrayList<String> services = new ArrayList<String>();
        for (Application app : registered) {
            log.info((Object)("Added service for " + app.getName()));
            services.add(app.getName().toLowerCase(Locale.getDefault()));
        }
        return services;
    }

    public void refresh() {
        log.info((Object)"Refresh");
        this.routesMap.clear();
        if (this.routesMapStatic.isEmpty()) {
            this.routesMapStatic.putAll(super.locateRoutes());
        } else {
            log.warn((Object)"Already loaded static routes");
        }
        List servicesLoad = this.getServices();
        for (String serviceId : servicesLoad) {
            String key = "/" + serviceId + "/**";
            this.routesMap.put(key, new ZuulProperties.ZuulRoute(key, serviceId));
        }
        log.info((Object)("Static Routes " + this.routesMapStatic));
        for (ZuulProperties.ZuulRoute route : this.routesMapStatic.values()) {
            if (!this.routesMap.containsKey(route.getPath())) {
                this.routesMap.put(route.getPath(), route);
                continue;
            }
            log.warn((Object)"Route already exists");
        }
        log.info((Object)("Routes result  to " + this.routesMap));
    }
}

