package groovy

def verifyGeracaoLaudo(def verificacaoGeracaoLaudoDTO) {

    def cnaesRiscoBaixo = ['4520006', '4644301', '4644302', '4679603', '4771701', '4771702', '4771703', '4771704', '5222200', '5240101',
                           '5611201', '8112500', '8511200', '8512100', '8513900', '8640204', '8640205', '8640206', '8640207', '8711505'];

    def cnaesRiscoLiberdadeEconomica = ['3312102', '3312104', '3313901', '3313902', '3313999', '3329501', '3329599', '3839401', '4110700', '4120400',
                                        '4211101', '4211102', '4212000', '4213800', '4221901', '4221904', '4222701', '4222702', '4223500', '4291000',
                                        '4292801', '4292802', '4299501', '4299599', '4311801', '4311802', '4312600', '4313400', '4319300', '4322302',
                                        '4322303', '4329101', '4329103', '4330402', '4399101', '4399102', '4399104', '4511101', '4511102', '4511103',
                                        '4511104', '4511105', '4511106', '4512901', '4512902', '4520008', '4530701', '4530702', '4530703', '4530704',
                                        '4530705', '4530706', '4541201', '4541202', '4541203', '4541204', '4541206', '4541207', '4542101', '4542102',
                                        '4543900', '4611700', '4612500', '4613300', '4614100', '4615000', '4616800', '4617600', '4618401', '4618402',
                                        '4618403', '4618499', '4619200', '4621400', '4622200', '4623101', '4623102', '4623103', '4623104', '4623105',
                                        '4623106', '4623107', '4623108', '4623109', '4623199', '4631100', '4632001', '4632002', '4632003', '4633801',
                                        '4633802', '4633803', '4634601', '4634602', '4634603', '4634699', '4635401', '4635402', '4635403', '4635499',
                                        '4636201', '4636202', '4637101', '4637102', '4637103', '4637104', '4637105', '4637106', '4637107', '4637199',
                                        '4639701', '4639702', '4641901', '4641902', '4641903', '4642701', '4642702', '4643501', '4643502', '4645101',
                                        '4645102', '4645103', '4646001', '4646002', '4647801', '4647802', '4649401', '4649402', '4649403', '4649404',
                                        '4649405', '4649406', '4649407', '4649408', '4649409', '4649410', '4649499', '4651601', '4651602', '4652400',
                                        '4661300', '4662100', '4663000', '4664800', '4665600', '4669901', '4669999', '4671100', '4672900', '4673700',
                                        '4674500', '4679601', '4679602', '4679604', '4679699', '4681805', '4683400', '4684201', '4684202', '4684299',
                                        '4685100', '4686901', '4686902', '4689301', '4689302', '4689399', '4691500', '4692300', '4693100', '4713002',
                                        '4713004', '4713005', '4721102', '4721103', '4721104', '4722901', '4722902', '4723700', '4724500', '4729601',
                                        '4729602', '4729699', '4732600', '4741500', '4742300', '4743100', '4744001', '4744002', '4744003', '4744004',
                                        '4744005', '4744006', '4744099', '4751201', '4751202', '4752100', '4753900', '4754701', '4754702', '4754703',
                                        '4755501', '4755502', '4755503', '4756300', '4757100', '4759801', '4759899', '4761001', '4761002', '4761003',
                                        '4762800', '4763601', '4763602', '4763603', '4763604', '4763605', '4772500', '4773300', '4774100', '4781400',
                                        '4782201', '4782202', '4783101', '4783102', '4785701', '4785799', '4789001', '4789002', '4789003', '4789004',
                                        '4789005', '4789006', '4789007', '4789008', '4789009', '4789099', '4929903', '4929904', '4929999', '5223100',
                                        '5250801', '5310501', '5310502', '5320201', '5320202', '5611203', '5611204', '5611205', '5612100', '5620101',
                                        '5620102', '5620103', '5620104', '5811500', '5812301', '5812302', '5813100', '5819100', '5911101', '5911102',
                                        '5911199', '5912001', '5912002', '5912099', '5913800', '5914600', '5920100', '6010100', '6021700', '6022501',
                                        '6022502', '6110801', '6110802', '6110803', '6110899', '6120501', '6120502', '6120599', '6130200', '6141800',
                                        '6142600', '6143400', '6190601', '6190602', '6190699', '6201501', '6201502', '6202300', '6203100', '6204000',
                                        '6209100', '6311900', '6319400', '6391700', '6399200', '6410700', '6421200', '6422100', '6423900', '6424701',
                                        '6424702', '6424703', '6424704', '6431000', '6432800', '6433600', '6434400', '6435201', '6435202', '6435203',
                                        '6436100', '6437900', '6438701', '6438799', '6440900', '6450600', '6461100', '6462000', '6463800', '6470101',
                                        '6470102', '6470103', '6491300', '6492100', '6493000', '6499901', '6499902', '6499903', '6499904', '6499905',
                                        '6499999', '6511101', '6511102', '6512000', '6520100', '6530800', '6541300', '6542100', '6550200', '6611801',
                                        '6611802', '6611803', '6611804', '6612601', '6612602', '6612603', '6612604', '6612605', '6613400', '6619301',
                                        '6619302', '6619303', '6619304', '6619305', '6619399', '6621501', '6621502', '6622300', '6629100', '6630400',
                                        '6810201', '6810202', '6810203', '6821801', '6821802', '6822600', '6911701', '6911702', '6911703', '6912500',
                                        '6920601', '6920602', '7020400', '7111100', '7112000', '7119701', '7119702', '7119703', '7119704', '7119799',
                                        '7120100', '7210000', '7220700', '7311400', '7312200', '7319001', '7319002', '7319003', '7319004', '7319099',
                                        '7320300', '7410202', '7410203', '7410299', '7420001', '7420002', '7420003', '7420004', '7420005', '7490101',
                                        '7490102', '7490103', '7490104', '7490105', '7490199', '7500100', '7711000', '7719501', '7719502', '7719599',
                                        '7721700', '7722500', '7723300', '7729201', '7729202', '7729203', '7729299', '7731400', '7732201', '7732202',
                                        '7733100', '7739001', '7739002', '7739003', '7739099', '7740300', '7810800', '7820500', '7830200', '7911200',
                                        '7912100', '7990200', '8011101', '8011102', '8012900', '8020001', '8020002', '8030700', '8111700', '8121400',
                                        '8129000', '8130300', '8211300', '8219901', '8219999', '8220200', '8230001', '8230002', '8291100', '8292000',
                                        '8299701', '8299702', '8299703', '8299704', '8299705', '8299706', '8299707', '8299799', '8411600', '8412400',
                                        '8413200', '8421300', '8422100', '8423000', '8424800', '8425600', '8430200', '8550301', '8550302', '8592901',
                                        '8592902', '8592903', '8592999', '8593700', '8599601', '8599602', '8599603', '8599604', '8599605', '8599699',
                                        '8650002', '8650003', '8650004', '8650005', '8650006', '8800600', '9001901', '9001902', '9001903', '9001904',
                                        '9001905', '9001906', '9001999', '9002701', '9002702', '9003500', '9101500', '9102301', '9102302', '9103100',
                                        '9200301', '9200302', '9200399', '9311500', '9312300', '9313100', '9319101', '9319199', '9321200', '9329801',
                                        '9329802', '9329803', '9329804', '9329899', '9411100', '9412001', '9412099', '9420100', '9430800', '9491000',
                                        '9492800', '9493600', '9499500', '9511800', '9512600', '9521500', '9529101', '9529102', '9529103', '9529104',
                                        '9529105', '9529106', '9529199', '9603303', '9609205', '9609207', '9609208', '9609299', '9700500', '9900800'];

    def retorno = GrauDeRiscoSMMA.RISCO_LIBERDADE_ECONOMICA.getSigla();

    if (cnaesRiscoLiberdadeEconomica.containsAll(verificacaoGeracaoLaudoDTO.atividades as String[])) {
        return retorno;
    }

    for (codigoAtividade in verificacaoGeracaoLaudoDTO.atividades) {

        if (!cnaesRiscoBaixo.contains(codigoAtividade) && !cnaesRiscoLiberdadeEconomica.contains(codigoAtividade)) {
            return GrauDeRiscoSMMA.RISCO_ALTO.getSigla();
        }

        if (cnaesRiscoBaixo.contains(codigoAtividade)) {
            retorno = GrauDeRiscoSMMA.RISCO_BAIXO.getSigla();
        }
    };

    return retorno;
}

enum GrauDeRiscoSMMA {

    RISCO_ALTO("C"),
    RISCO_BAIXO("B"),
    RISCO_LIBERDADE_ECONOMICA("A");

    private final String sigla;

    GrauDeRiscoSMMA(String sigla) {
        this.sigla = sigla;
    }

    String getSigla() {
        return sigla;
    }
}