package groovy

def verifyGeracaoLaudo(def verificacaoGeracaoLaudoDTO) {

    def cnaesRiscoAlto = ['1011201', '1011202', '1011203', '1011204', '1011205', '1012101', '1012102', '1012103',
                          '1012104', '1013901', '1013902', '1020101', '1020102', '1051100', '1052000', '4633803',
                          '4634601', '4634602', '4634603', '4634699'];

   def retorno = GrauDeRiscoSMAPA.RISCO_LIBERDADE_ECONOMICA.getSigla();

   for (codigoAtividade in verificacaoGeracaoLaudoDTO.atividades) {

        if (cnaesRiscoAlto.contains(codigoAtividade)) {
            return GrauDeRiscoSMAPA.RISCO_ALTO.getSigla();
        }
    };

    return retorno;
}

enum GrauDeRiscoSMAPA {

    RISCO_ALTO("C"),
    RISCO_LIBERDADE_ECONOMICA("A");

    private final String sigla;

    GrauDeRiscoSMAPA(String sigla) {
        this.sigla = sigla;
    }

    String getSigla() {
        return sigla;
    }
}