package groovy

def verifyGeracaoLaudo(def verificacaoGeracaoLaudoDTO) {

    def cnaesRiscoAlto = ['0600001', '0600002', '0600003', '0910600', '1111901', '1111902', '1921700', '1922501',
                          '1922599', '1931400', '1932200', '2021500', '2022300', '2029100', '2071100', '2073800',
                          '2092401', '2092402', '2092403', '3520401', '3520402', '4681801', '4681802', '4681803',
                          '4681804', '4682600', '4684201', '4684202', '4684299', '4731800', '4784900', '4789006',
                          '8230002', '8423000', '8511200', '8512100', '8610101', '8630501', '8711501', '8711502',
                          '8711503', '8711504', '8711505', '8720401', '8720499', '8730101', '8730102', '8730199',
                          '9001904', '9001905', '9312300', '9321200', '9329801', '9329802', '9329803', '9329804',
                          '9329899'];

    def retorno = GrauDeRiscoFazenda.RISCO_LIBERDADE_ECONOMICA.getSigla();

    if (Objects.nonNull(verificacaoGeracaoLaudoDTO.solicitacaoAlvaraRedeSimDTO)) {
        if (Objects.nonNull(verificacaoGeracaoLaudoDTO.solicitacaoAlvaraRedeSimDTO.dados_solicitacao.empresa.endereco) && Objects.nonNull(verificacaoGeracaoLaudoDTO.solicitacaoAlvaraRedeSimDTO.dados_solicitacao.empresa.endereco.nu_area_utilizada)) {
            if (Double.parseDouble(verificacaoGeracaoLaudoDTO.solicitacaoAlvaraRedeSimDTO.dados_solicitacao.empresa.endereco.nu_area_utilizada) > 1000) {
                return GrauDeRiscoFazenda.RISCO_ALTO.getSigla();
            }
        }
    }

    if (Objects.nonNull(verificacaoGeracaoLaudoDTO.solicitacaoAlvaraRedeSimDTO)) {
        if (Objects.nonNull(verificacaoGeracaoLaudoDTO.solicitacaoAlvaraRedeSimDTO.dados_solicitacao.classificacao_risco)) {
            if (Objects.nonNull(verificacaoGeracaoLaudoDTO.solicitacaoAlvaraRedeSimDTO.dados_solicitacao.classificacao_risco.pergunta_classificacao_risco)) {
                for (perguntaClassificacaoRisco in verificacaoGeracaoLaudoDTO.solicitacaoAlvaraRedeSimDTO.dados_solicitacao.classificacao_risco.pergunta_classificacao_risco) {
                    ClassificacaoRiscoBombeiros classificacaoRiscoBombeiros = ClassificacaoRiscoBombeiros.findByCodPergunta(perguntaClassificacaoRisco.co_identificador_pergunta);

                    if (classificacaoRiscoBombeiros != null) {
                        if (Integer.valueOf(perguntaClassificacaoRisco.ds_resposta) > classificacaoRiscoBombeiros.valorResposta) {
                            return GrauDeRiscoFazenda.RISCO_ALTO.getSigla();
                        }
                    }
                }
            }
        }
    }

    for (codigoAtividade in verificacaoGeracaoLaudoDTO.atividades) {

        if (cnaesRiscoAlto.contains(codigoAtividade)) {
            return GrauDeRiscoFazenda.RISCO_ALTO.getSigla();
        }
    };

    return retorno;
}

enum GrauDeRiscoFazenda {

    RISCO_ALTO("C"),
    RISCO_LIBERDADE_ECONOMICA("A");

    private final String sigla;

    GrauDeRiscoFazenda(String sigla) {
        this.sigla = sigla;
    }

    String getSigla() {
        return sigla;
    }
}

enum ClassificacaoRiscoBombeiros {
    QUANTIDADE_PESSOAS_AMBIENTE("CGSIM-0004", 100),
    LITROS_LIQUIDO_INFLAMAVEL("CGSIM-0006", 250),
    KG_GAS_LIQUEFEITO("CGSIM-0007", 190),
    QUANTIDADE_PAVIMENTOS("CGSIM-0003", 2)

    private final String codPergunta
    private final Integer valorResposta;

    ClassificacaoRiscoBombeiros(String codPergunta, Integer valorResposta) {
        this.valorResposta = valorResposta;
        this.codPergunta = codPergunta;
    }

    static ClassificacaoRiscoBombeiros findByCodPergunta(String codigoPergunta) {
        for (ClassificacaoRiscoBombeiros valEnum : ClassificacaoRiscoBombeiros.values()) {
            if (valEnum.codPergunta == codigoPergunta) {
                return valEnum;
            }
        }
    }
}