/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.ws.oxm.geo;

import br.com.elotech.portalarrecadacao.ws.oxm.geo.Laudo;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RespostaWSAtividade;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RetornoConsultaAtividade;
import br.com.elotech.tributacao.enumerator.TipoLaudoEnum;
import br.com.elotech.util.list.EloListUtils;
import java.util.List;

public class RetornaAtividadeResponse {
    private RespostaWSAtividade respostaWSAtividade;
    private RetornoConsultaAtividade retornoConsultaAtividade;

    public RespostaWSAtividade getRespostaWSAtividade() {
        return this.respostaWSAtividade;
    }

    public RetornoConsultaAtividade getRetornoConsultaAtividade() {
        return this.retornoConsultaAtividade;
    }

    public void setRetornoConsultaAtividade(RetornoConsultaAtividade retornoConsultaAtividade) {
        this.retornoConsultaAtividade = retornoConsultaAtividade;
    }

    public void setRespostaWSAtividade(RespostaWSAtividade respostaWSAtividade) {
        this.respostaWSAtividade = respostaWSAtividade;
    }

    public boolean possuiLaudoAmbiental() {
        if (this.respostaWSAtividade != null) {
            for (Laudo laudoItem : this.respostaWSAtividade.getLaudos().getLaudo()) {
                if (Long.valueOf(laudoItem.getCodigo().longValue()).compareTo(TipoLaudoEnum.AMBIENTAL.getCodigo()) != 0) continue;
                return true;
            }
            return false;
        }
        if (!EloListUtils.safeIsEmpty((List)this.retornoConsultaAtividade.getAtividade().getExigencias()).booleanValue()) {
            return this.retornoConsultaAtividade.getAtividade().getExigencias().stream().anyMatch(exigenciaGeo -> exigenciaGeo.isLaudoAmbiental());
        }
        return false;
    }

    public boolean possuiLaudoBombeiro() {
        if (this.respostaWSAtividade != null) {
            for (Laudo laudoItem : this.respostaWSAtividade.getLaudos().getLaudo()) {
                if (Long.valueOf(laudoItem.getCodigo().longValue()).compareTo(TipoLaudoEnum.BOMBEIRO.getCodigo()) != 0) continue;
                return true;
            }
            return false;
        }
        if (!EloListUtils.safeIsEmpty((List)this.retornoConsultaAtividade.getAtividade().getExigencias()).booleanValue()) {
            return this.retornoConsultaAtividade.getAtividade().getExigencias().stream().anyMatch(exigenciaGeo -> exigenciaGeo.isLaudoBombeiro());
        }
        return false;
    }

    public boolean possuiLaudoPostura() {
        if (this.respostaWSAtividade != null) {
            for (Laudo laudoItem : this.respostaWSAtividade.getLaudos().getLaudo()) {
                if (Long.valueOf(laudoItem.getCodigo().longValue()).compareTo(TipoLaudoEnum.POSTURA.getCodigo()) != 0) continue;
                return true;
            }
            return false;
        }
        if (!EloListUtils.safeIsEmpty((List)this.retornoConsultaAtividade.getAtividade().getExigencias()).booleanValue()) {
            return this.retornoConsultaAtividade.getAtividade().getExigencias().stream().anyMatch(exigenciaGeo -> exigenciaGeo.isLaudoPostura());
        }
        return false;
    }

    public boolean possuiLaudoTransporte() {
        if (this.respostaWSAtividade != null) {
            for (Laudo laudoItem : this.respostaWSAtividade.getLaudos().getLaudo()) {
                if (Long.valueOf(laudoItem.getCodigo().longValue()).compareTo(TipoLaudoEnum.TRANSPORTE.getCodigo()) != 0) continue;
                return true;
            }
            return false;
        }
        if (!EloListUtils.safeIsEmpty((List)this.retornoConsultaAtividade.getAtividade().getExigencias()).booleanValue()) {
            return this.retornoConsultaAtividade.getAtividade().getExigencias().stream().anyMatch(exigenciaGeo -> exigenciaGeo.isLaudoTransporte());
        }
        return false;
    }

    public boolean possuiLaudoVigSanitaria() {
        if (this.respostaWSAtividade != null) {
            for (Laudo laudoItem : this.respostaWSAtividade.getLaudos().getLaudo()) {
                if (Long.valueOf(laudoItem.getCodigo().longValue()).compareTo(TipoLaudoEnum.VIGILANCIA_SANITARIA.getCodigo()) != 0) continue;
                return true;
            }
            return false;
        }
        if (!EloListUtils.safeIsEmpty((List)this.retornoConsultaAtividade.getAtividade().getExigencias()).booleanValue()) {
            return this.retornoConsultaAtividade.getAtividade().getExigencias().stream().anyMatch(exigenciaGeo -> exigenciaGeo.isLaudoVigilanciaSanitaria());
        }
        return false;
    }
}

