/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.ws.oxm.geo;

import br.com.elotech.portalarrecadacao.ws.oxm.geo.ArrayOfExigencia;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.ArrayOfLaudo;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.ArrayOfMotivo;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.Exigencia;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.Motivo;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.Proibicao;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RestricaoPermissivel;
import br.com.elotech.util.list.EloListUtils;
import java.io.Serializable;
import java.util.List;

public class RespostaWSAtividade
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean atividadePermitida;
    private boolean verificarProprietario;
    private ArrayOfMotivo motivos;
    private Proibicao proibicao;
    private String zona;
    private String eixo;
    private ArrayOfExigencia exigencias;
    private String codTaxa;
    private String grauRisco;
    private ArrayOfLaudo laudos;
    private String codIss;
    private RestricaoPermissivel restricaoPermissivel;

    public boolean isAtividadePermitida() {
        return this.atividadePermitida;
    }

    public void setAtividadePermitida(boolean atividadePermitida) {
        this.atividadePermitida = atividadePermitida;
    }

    public boolean isVerificarProprietario() {
        return this.verificarProprietario;
    }

    public void setVerificarProprietario(boolean verificarProprietario) {
        this.verificarProprietario = verificarProprietario;
    }

    public Proibicao getProibicao() {
        return this.proibicao;
    }

    public void setProibicao(Proibicao proibicao) {
        this.proibicao = proibicao;
    }

    public String getZona() {
        return this.zona;
    }

    public void setZona(String zona) {
        this.zona = zona;
    }

    public String getEixo() {
        return this.eixo;
    }

    public void setEixo(String eixo) {
        this.eixo = eixo;
    }

    public String getCodTaxa() {
        return this.codTaxa;
    }

    public void setCodTaxa(String codTaxa) {
        this.codTaxa = codTaxa;
    }

    public String getGrauRisco() {
        return this.grauRisco;
    }

    public void setGrauRisco(String grauRisco) {
        this.grauRisco = grauRisco;
    }

    public String getCodIss() {
        return this.codIss;
    }

    public ArrayOfLaudo getLaudos() {
        return this.laudos;
    }

    public void setLaudos(ArrayOfLaudo laudos) {
        this.laudos = laudos;
    }

    public void setCodIss(String codIss) {
        this.codIss = codIss;
    }

    public RestricaoPermissivel getRestricaoPermissivel() {
        return this.restricaoPermissivel;
    }

    public void setRestricaoPermissivel(RestricaoPermissivel restricaoPermissivel) {
        this.restricaoPermissivel = restricaoPermissivel;
    }

    public String getMotivosDescricao() {
        StringBuilder strBuilder = new StringBuilder();
        for (Motivo motivo : this.motivos.getMotivo()) {
            strBuilder.append(motivo.getDescricao());
            strBuilder.append(", ");
        }
        return strBuilder.toString();
    }

    public boolean exigeResponsavelTecnico() {
        if (!EloListUtils.safeIsEmpty((List)this.exigencias.getExigencia()).booleanValue()) {
            for (Exigencia exigencia : this.exigencias.getExigencia()) {
                if (!exigencia.isResponsavelTecnico()) continue;
                return true;
            }
        }
        return false;
    }

    public String carregarDescricaoExigencia() {
        StringBuilder str = new StringBuilder();
        for (Exigencia exigencia : this.exigencias.getExigencia()) {
            str.append(exigencia.getDescricao());
        }
        return str.toString();
    }

    public ArrayOfMotivo getMotivos() {
        return this.motivos;
    }

    public void setMotivos(ArrayOfMotivo motivos) {
        this.motivos = motivos;
    }

    public ArrayOfExigencia getExigencias() {
        return this.exigencias;
    }

    public void setExigencias(ArrayOfExigencia exigencias) {
        this.exigencias = exigencias;
    }
}

