/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.ws.interceptor;

import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.ws.interceptor.MessageListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.springframework.ws.client.WebServiceClientException;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.context.MessageContext;

public class MessageInterceptor
extends EloLogger
implements ClientInterceptor {
    private List<MessageListener> listeners;
    private static Log log = LogFactory.getLog(MessageInterceptor.class);

    public List<MessageListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<MessageListener> listeners) {
        this.listeners = listeners;
    }

    public boolean handleRequest(MessageContext messageContext) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            messageContext.getRequest().writeTo((OutputStream)bos);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        StringBuilder request = new StringBuilder();
        request.append("\n <----- REQUEST ----->\n");
        request.append(this.formatXml(bos.toString()));
        request.append("\n <----- REQUEST ----->\n");
        log.info((Object)request.toString());
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            messageContext.getResponse().writeTo((OutputStream)bos);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        StringBuilder response = new StringBuilder();
        response.append("\n <----- RESPONSE ----->\n");
        response.append(UtilsController.formatXml((String)bos.toString()));
        response.append("\n <----- RESPONSE ----->\n");
        log.info((Object)response.toString());
        return true;
    }

    public boolean handleFault(MessageContext messageContext) throws WebServiceClientException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            messageContext.getResponse().writeTo((OutputStream)bos);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        StringBuilder response = new StringBuilder();
        response.append("\n <----- RESPONSE FAULT ----->\n");
        response.append(this.formatXml(bos.toString()));
        response.append("\n <----- RESPONSE FAULT ----->\n");
        log.info((Object)response.toString());
        return false;
    }

    private String formatXml(String xml) {
        StringWriter sw;
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            Document document = DocumentHelper.parseText((String)xml);
            sw = new StringWriter();
            XMLWriter writer = new XMLWriter((Writer)sw, format);
            writer.write(document);
        }
        catch (Exception e) {
            throw new RuntimeException("Error pretty printing xml:\n" + xml, e);
        }
        return sw.toString();
    }

    public void afterCompletion(MessageContext messageContext, Exception ex) throws WebServiceClientException {
    }
}

