/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.validator;

import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.util.service.impl.SrvValidarCnpjCpfImpl;
import br.com.elotech.util.service.providers.ValidarCnpjCpfProvider;
import br.com.elotech.util.service.providers.impl.ValidarCnpjCpfCaelumProvider;
import br.com.elotech.util.string.EloStringUtils;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value="cpfCnpjValidador")
public class CpfCnpjValidador
implements Validator {
    public static final String ID_MESSAGE_DEFAULT = "validacao";
    ValidarCnpjCpfProvider v;
    SrvValidarCnpjCpfImpl srv;
    String idMessage = "validacao";

    public CpfCnpjValidador() {
        this.iniciarAtributos();
    }

    public void setIdMessage(String idMessage) {
        this.idMessage = idMessage;
    }

    public void validate(FacesContext context, UIComponent component, Object value) {
        this.iniciarAtributos();
        if (!this.validarCpfCnpj((String)value)) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, "CPF/CNPJ Inv\u00e1lido", "");
            throw new ValidatorException(message);
        }
    }

    public boolean validarCpfCnpj(String cpfCnpj) {
        this.iniciarAtributos();
        if (!(EloStringUtils.isEmpty((String)cpfCnpj) || this.srv.validarCnpjCpf(cpfCnpj) && !this.isCnpjZero(cpfCnpj))) {
            ShowMessage.addErrorMessage((String)this.idMessage, (String)"CPF/CNPJ Inv\u00e1lido");
            return false;
        }
        return true;
    }

    public void iniciarAtributos() {
        if (this.v == null || this.srv == null) {
            this.v = new ValidarCnpjCpfCaelumProvider();
            this.srv = new SrvValidarCnpjCpfImpl();
            this.idMessage = ID_MESSAGE_DEFAULT;
        }
        this.srv.setProvider(this.v);
    }

    public void limpaAtributos() {
        this.v = null;
        this.srv = null;
        this.idMessage = ID_MESSAGE_DEFAULT;
    }

    public boolean isCnpjZero(String cnpj) {
        return cnpj.equals("00000000000000");
    }
}

