/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.portalarrecadacao.service.SrvVerificaExigenciaCnae;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.Exigencia;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.ExigenciaGeo;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RespostaWSAtividade;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RetornoConsultaAtividade;
import br.com.elotech.util.list.EloListUtils;
import java.util.HashSet;
import java.util.List;

@EloService(value="srvVerificaExigenciaCnae")
public class SrvVerificaExigenciaCnaeImpl
implements SrvVerificaExigenciaCnae {
    public Boolean verificaRestricaoRespTecVigSanitaria(List<RespostaWSAtividade> respostaWSAtividades) {
        for (RespostaWSAtividade respostaWSAtividade : respostaWSAtividades) {
            if (EloListUtils.safeIsEmpty((List)respostaWSAtividade.getExigencias().getExigencia()).booleanValue()) continue;
            for (Exigencia exigencia : respostaWSAtividade.getExigencias().getExigencia()) {
                if (!exigencia.isResponsavelTecnicoVigilanciaSanitaria()) continue;
                return true;
            }
        }
        return false;
    }

    public Boolean verificaRestricaoRespTecVigAmbiental(List<RespostaWSAtividade> respostaWSAtividades) {
        for (RespostaWSAtividade respostaWSAtividade : respostaWSAtividades) {
            if (EloListUtils.safeIsEmpty((List)respostaWSAtividade.getExigencias().getExigencia()).booleanValue()) continue;
            for (Exigencia exigencia : respostaWSAtividade.getExigencias().getExigencia()) {
                if (!exigencia.isResponsavelTecnicoVigilanciaAmbiental()) continue;
                return true;
            }
        }
        return false;
    }

    public Boolean verificaRestricaoRespTecMeioAmbiente(List<RespostaWSAtividade> respostaWSAtividades) {
        for (RespostaWSAtividade respostaWSAtividade : respostaWSAtividades) {
            if (EloListUtils.safeIsEmpty((List)respostaWSAtividade.getExigencias().getExigencia()).booleanValue()) continue;
            for (Exigencia exigencia : respostaWSAtividade.getExigencias().getExigencia()) {
                if (!exigencia.isResponsavelTecnicoMeioAmbiente()) continue;
                return true;
            }
        }
        return false;
    }

    public String verificaExigenciasNovoGeo(List<RetornoConsultaAtividade> listaRetornoConsultaAtividade) {
        StringBuilder exigencias = new StringBuilder();
        HashSet<ExigenciaGeo> validacaoExigencias = new HashSet<ExigenciaGeo>();
        for (RetornoConsultaAtividade retornoConsultaAtividade : listaRetornoConsultaAtividade) {
            if (EloListUtils.safeIsEmpty((List)retornoConsultaAtividade.getAtividade().getExigencias()).booleanValue()) continue;
            for (ExigenciaGeo exigencia : retornoConsultaAtividade.getAtividade().getExigencias()) {
                validacaoExigencias.add(exigencia);
            }
        }
        for (ExigenciaGeo exigencia : validacaoExigencias) {
            exigencias.append(exigencia.getDescricao());
            exigencias.append("<br>");
        }
        return exigencias.toString();
    }

    public String verificaExigencias(List<RespostaWSAtividade> listaRespostaWSAtividade) {
        StringBuilder exigencias = new StringBuilder();
        HashSet<Exigencia> validacaoExigencias = new HashSet<Exigencia>();
        for (RespostaWSAtividade respostaWSAtividade : listaRespostaWSAtividade) {
            if (EloListUtils.safeIsEmpty((List)respostaWSAtividade.getExigencias().getExigencia()).booleanValue()) continue;
            for (Exigencia exigencia : respostaWSAtividade.getExigencias().getExigencia()) {
                validacaoExigencias.add(exigencia);
            }
        }
        for (Exigencia exigencia : validacaoExigencias) {
            exigencias.append(exigencia.getDescricao());
            exigencias.append("<br>");
        }
        return exigencias.toString();
    }
}

