/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraNaturezaEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraNaturezaEnum;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.repository.RepositoryParametroAlvaraNatureza;
import br.com.elotech.portalarrecadacao.service.SrvValidaTipoSegmentoImovel;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioSegmentoEntity;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.repository.aise.RepositoryImobiliarioSegmento;
import br.com.elotech.util.string.EloStringUtils;
import java.util.List;
import javax.annotation.Resource;

@EloService(value="srvValidaTipoSegmentoImovel")
public class SrvValidaTipoSegmentoImovelImpl
extends EloLogger
implements SrvValidaTipoSegmentoImovel {
    @Resource
    private RepositoryParametroAlvaraNatureza repositoryParametroAlvaraNatureza;
    @Resource
    private RepositoryImobiliarioSegmento repositoryImobiliarioSegmento;

    public boolean validaSegmentoSolicitacaoPrestadorServico(SolicitacaoAlvaraEntity solicitacao) throws SolicitacaoAlvaraException {
        NaturezaSolicitacaoAlvaraEntity natureza = null;
        try {
            if (solicitacao.isSolicitacaoPrestadorServico() || solicitacao.isSolicitacaoMEIPrestador()) {
                if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL})) {
                    natureza = solicitacao.getNatureza(NaturezaSolicitacaoAlvaraEnum.INICIAL);
                } else if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO})) {
                    natureza = solicitacao.getNatureza(NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO);
                }
                if (natureza != null) {
                    ParametroAlvaraNaturezaEntity paramTipoSegNaoLibera = this.getParametroNatureza(natureza, ParametroAlvaraNaturezaEnum.VALIDATIPOSEGMENTONAOLIBERA, solicitacao.getTipoDeInscricao());
                    ParametroAlvaraNaturezaEntity paramTipoSegLibera = this.getParametroNatureza(natureza, ParametroAlvaraNaturezaEnum.VALIDATIPOSEGMENTOLIBERA, solicitacao.getTipoDeInscricao());
                    if (paramTipoSegNaoLibera == null || paramTipoSegLibera == null) {
                        return true;
                    }
                    return this.validaSegmentos(paramTipoSegNaoLibera, paramTipoSegLibera, solicitacao.getCadastroImobiliario());
                }
            }
            return true;
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException("Falha na valida\u00e7\u00e3o de tipo de segmento do im\u00f3vel");
        }
    }

    private boolean validaSegmentos(ParametroAlvaraNaturezaEntity paramTipoSegNaoLibera, ParametroAlvaraNaturezaEntity paramTipoSegLibera, CadastroImobiliarioEntity cadastroImobiliario) throws BaseException {
        Long[] tiposSegNaoLibera = EloStringUtils.strToLong((String[])paramTipoSegNaoLibera.getValor().split(","));
        Long[] tiposSegLibera = EloStringUtils.strToLong((String[])paramTipoSegLibera.getValor().split(","));
        boolean tipoSegNaoLibera = this.verificarTipoSegImobiliario(tiposSegNaoLibera, cadastroImobiliario);
        boolean tipoSeguimentoLibera = this.verificarTipoSegImobiliario(tiposSegLibera, cadastroImobiliario);
        return !tipoSegNaoLibera || tipoSeguimentoLibera;
    }

    private ParametroAlvaraNaturezaEntity getParametroNatureza(NaturezaSolicitacaoAlvaraEntity natureza, ParametroAlvaraNaturezaEnum param, TipoInscricaoAlvaraEntity tipoInscricao) throws BaseException {
        return this.repositoryParametroAlvaraNatureza.getParametroAlvaraNatureza(natureza, param, tipoInscricao);
    }

    private boolean verificarTipoSegImobiliario(Long[] tipoSegCompara, CadastroImobiliarioEntity cadastroImobiliario) throws BaseException {
        List imobiliarioSegmentos = this.repositoryImobiliarioSegmento.getImobiliarioSegmentoPorCadastroImobiliairo(cadastroImobiliario.getCadastroGeral());
        boolean possuiTipoSeg = false;
        block0: for (CadastroImobiliarioSegmentoEntity imobSegmento : imobiliarioSegmentos) {
            for (Long tipoSegNLibera : tipoSegCompara) {
                if (!imobSegmento.getTipoSegmento().getTipoSegmento().equals(tipoSegNLibera)) continue;
                possuiTipoSeg = true;
                continue block0;
            }
        }
        return possuiTipoSeg;
    }
}

