/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import java.util.InputMismatchException;

/*
 * Exception performing whole class analysis ignored.
 */
public class SrvValidaCpfImpl {
    public static boolean isValidCPF(String cpf) {
        int d2 = 0;
        int d1 = 0;
        int resto = 0;
        int digito2 = 0;
        int digito1 = 0;
        if (cpf.equals("00000000000") || cpf.equals("11111111111") || cpf.equals("22222222222") || cpf.equals("33333333333") || cpf.equals("44444444444") || cpf.equals("55555555555") || cpf.equals("66666666666") || cpf.equals("77777777777") || cpf.equals("88888888888") || cpf.equals("99999999999") || cpf.length() != 11) {
            return false;
        }
        for (int nCount = 1; nCount < cpf.length() - 1; ++nCount) {
            int digitoCPF = Integer.valueOf(cpf.substring(nCount - 1, nCount));
            d1 += (11 - nCount) * digitoCPF;
            d2 += (12 - nCount) * digitoCPF;
        }
        resto = d1 % 11;
        digito1 = resto < 2 ? 0 : 11 - resto;
        resto = (d2 += 2 * digito1) % 11;
        digito2 = resto < 2 ? 0 : 11 - resto;
        String nDigVerific = cpf.substring(cpf.length() - 2, cpf.length());
        String nDigResult = String.valueOf(digito1) + String.valueOf(digito2);
        return nDigVerific.equals(nDigResult);
    }

    public static boolean isValidCNPJ(String cnpj) {
        if (cnpj.equals("00000000000000") || cnpj.equals("11111111111111") || cnpj.equals("22222222222222") || cnpj.equals("33333333333333") || cnpj.equals("44444444444444") || cnpj.equals("55555555555555") || cnpj.equals("66666666666666") || cnpj.equals("77777777777777") || cnpj.equals("88888888888888") || cnpj.equals("99999999999999") || cnpj.length() != 14) {
            return false;
        }
        try {
            int num;
            int i;
            int sm = 0;
            int peso = 2;
            for (i = 11; i >= 0; --i) {
                num = cnpj.charAt(i) - 48;
                sm += num * peso;
                if (++peso != 10) continue;
                peso = 2;
            }
            int r = sm % 11;
            char dig13 = r == 0 || r == 1 ? (char)'0' : (char)((char)(11 - r + 48));
            sm = 0;
            peso = 2;
            for (i = 12; i >= 0; --i) {
                num = cnpj.charAt(i) - 48;
                sm += num * peso;
                if (++peso != 10) continue;
                peso = 2;
            }
            r = sm % 11;
            char dig14 = r == 0 || r == 1 ? (char)'0' : (char)((char)(11 - r + 48));
            return dig13 == cnpj.charAt(12) && dig14 == cnpj.charAt(13);
        }
        catch (InputMismatchException erro) {
            return false;
        }
    }

    public static String imprimeCNPJ(String cnpj) {
        String cnpjOk = cnpj.substring(0, 2) + "." + cnpj.substring(2, 5) + "." + cnpj.substring(5, 8) + "." + cnpj.substring(8, 12) + "-" + cnpj.substring(12, 14);
        return cnpjOk;
    }

    public static String imprimeCPF(String cpf) {
        String cpfOk = cpf.substring(0, 3) + "." + cpf.substring(3, 6) + "." + cpf.substring(6, 9) + "-" + cpf.substring(9, 11);
        return cpfOk;
    }

    public static String printDocumento(String documento) {
        if (documento.length() == 11) {
            return SrvValidaCpfImpl.imprimeCPF((String)documento);
        }
        if (documento.length() == 14) {
            return SrvValidaCpfImpl.imprimeCNPJ((String)documento);
        }
        return "";
    }

    public static boolean isDocumentoValido(String documento) {
        return documento.length() == 11 ? SrvValidaCpfImpl.isValidCPF((String)documento) : documento.length() == 14 && SrvValidaCpfImpl.isValidCNPJ((String)documento);
    }

    public static void main(String[] args) {
        String cpf = "06945410951";
        System.out.println(cpf + " = " + SrvValidaCpfImpl.imprimeCPF((String)cpf));
        System.out.println("isValidCPF[" + SrvValidaCpfImpl.isValidCPF((String)cpf) + "]");
        System.out.println("isDocumentoValido[" + SrvValidaCpfImpl.isDocumentoValido((String)cpf) + "]\n");
        cpf = "99999999999";
        System.out.println(cpf + " = " + SrvValidaCpfImpl.imprimeCPF((String)cpf));
        System.out.println("isValidCPF[" + SrvValidaCpfImpl.isValidCPF((String)cpf) + "]");
        System.out.println("isDocumentoValido[" + SrvValidaCpfImpl.isDocumentoValido((String)cpf) + "]\n");
        String cnpj = "78132937000108";
        System.out.println(cnpj + " = " + SrvValidaCpfImpl.imprimeCNPJ((String)cnpj));
        System.out.println("isValidCNPJ[" + SrvValidaCpfImpl.isValidCNPJ((String)cnpj) + "]");
        System.out.println("isDocumentoValido[" + SrvValidaCpfImpl.isDocumentoValido((String)cnpj) + "]\n");
        cnpj = "99999999999999";
        System.out.println(cnpj + " = " + SrvValidaCpfImpl.imprimeCNPJ((String)cnpj));
        System.out.println("isValidCNPJ[" + SrvValidaCpfImpl.isValidCNPJ((String)cnpj) + "]");
        System.out.println("isDocumentoValido[" + SrvValidaCpfImpl.isDocumentoValido((String)cnpj) + "]\n");
    }
}

