/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoDocRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.UrlArquivoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroConsultaRedeSim;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Arquivo;
import br.com.elotech.portalarrecadacao.repository.RepositoryConsultaRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoDocRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryUrlArquivoRedeSim;
import br.com.elotech.portalarrecadacao.rest.dto.Dados_solicitacao_documento;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoDocumentosDTO;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraRedeSim;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoDocumentoRedeSim;
import br.com.elotech.portalarrecadacao.service.impl.SrvSolicitacaoAlvaraImpl;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.util.list.EloListUtils;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;

@EloService
public class SrvSolicitacaoDocumentoRedeSimImpl
extends SrvSolicitacaoAlvaraImpl
implements SrvSolicitacaoDocumentoRedeSim {
    @Resource
    private RepositorySolicitacaoDocRedeSim repositorySolicitacaoDocRedeSim;
    @Resource
    private RepositoryUrlArquivoRedeSim repositoryUrlArquivoRedeSim;
    @Resource
    private RepositoryConsultaRedeSim repositoryConsultaRedeSim;
    @Resource
    private SrvSolicitacaoAlvaraRedeSim srvSolicitacaoAlvaraRedeSim;

    public void setSrvSolicitacaoAlvaraRedeSim(SrvSolicitacaoAlvaraRedeSim srvSolicitacaoAlvaraRedeSim) {
        this.srvSolicitacaoAlvaraRedeSim = srvSolicitacaoAlvaraRedeSim;
    }

    public void setRepositorySolicitacaoDocRedeSim(RepositorySolicitacaoDocRedeSim repositorySolicitacaoDocRedeSim) {
        this.repositorySolicitacaoDocRedeSim = repositorySolicitacaoDocRedeSim;
    }

    public void setRepositoryUrlArquivoRedeSim(RepositoryUrlArquivoRedeSim repositoryUrlArquivoRedeSim) {
        this.repositoryUrlArquivoRedeSim = repositoryUrlArquivoRedeSim;
    }

    public void setRepositoryConsultaRedeSim(RepositoryConsultaRedeSim repositoryConsultaRedeSim) {
        this.repositoryConsultaRedeSim = repositoryConsultaRedeSim;
    }

    public SolicitacaoDocRedeSimEntity salvarSolicitacaoDocumento(SolicitacaoDocumentosDTO solicitacaoDocumentosDTO) throws BaseException {
        SolicitacaoDocRedeSimEntity solicitacaoDoc = new SolicitacaoDocRedeSimEntity();
        solicitacaoDoc.setData(new Date());
        solicitacaoDoc.setId(this.repositorySolicitacaoDocRedeSim.getSequence());
        solicitacaoDoc.setFinalizado(SimNaoEnum.getNaoShortText());
        solicitacaoDoc.setProcessadoAutomatico(SimNaoEnum.getNaoShortText());
        solicitacaoDoc.setProtocolo(solicitacaoDocumentosDTO.getDados_solicitacao_documento().getCo_protocolo_redesim());
        Long tipoModeloDocumento = Optional.ofNullable(solicitacaoDocumentosDTO.getDados_solicitacao_documento()).filter(item -> Objects.nonNull(item.getCo_tipo_modelo_documento())).map(Dados_solicitacao_documento::getCo_tipo_modelo_documento).map(Long::valueOf).orElse(null);
        solicitacaoDoc.setTipoModeloDocumento(tipoModeloDocumento);
        Gson gson = new Gson();
        solicitacaoDoc.setArquivoSolicitacao(gson.toJson((Object)solicitacaoDocumentosDTO));
        solicitacaoDoc.setUrlArquivos(this.getUrlArquivos(solicitacaoDocumentosDTO.getDados_solicitacao_documento().getAnexos(), solicitacaoDoc));
        return this.repositorySolicitacaoDocRedeSim.saveOrUpdate(solicitacaoDoc);
    }

    protected List<UrlArquivoRedeSimEntity> getUrlArquivos(List<Arquivo> arquivos, SolicitacaoDocRedeSimEntity solicitacaoDoc) {
        ArrayList urls = Lists.newArrayList();
        if (!EloListUtils.safeIsEmpty(arquivos).booleanValue()) {
            arquivos.stream().forEach(a -> {
                UrlArquivoRedeSimEntity urlArquivo = new UrlArquivoRedeSimEntity();
                urlArquivo.setIdSolicitacaoDoc(solicitacaoDoc);
                urlArquivo.setUrl(a.getDs_url_servico());
                urlArquivo.setId(this.repositoryUrlArquivoRedeSim.getSequence());
                urlArquivo.setValidado(false);
                urls.add(urlArquivo);
            });
        }
        return urls;
    }

    public void atualizarSolicitacaoRedeSimAguardandoSolicitacaoDoc() throws BaseException {
        List solicitacoesRedeSim = this.getSolicitacaoAguardandoSolicitacaoDocumento();
        Optional obs = Optional.empty();
        for (SolicitacaoRedeSimEntity solicitacao : solicitacoesRedeSim) {
            if (!this.finalizarSolicitacaoDoc(solicitacao)) continue;
            this.srvSolicitacaoAlvaraRedeSim.adicionarHistoricoDeAndamento(solicitacao, SituacaoConsultaPreviaRedeSimEnum.ANALISE, obs, null);
        }
    }

    public boolean existsSolicitacaoDocumentoRedeSimByProtocoloAndTipoDocumento(String protocolo, Long tipoDocumento) throws BaseException {
        List solicitacoesDoc = this.repositorySolicitacaoDocRedeSim.findSolicitacaoDocumentoByProtocoloAndTipoDocumento(protocolo, tipoDocumento);
        return EloListUtils.safeIsEmpty((List)solicitacoesDoc) == false;
    }

    protected boolean finalizarSolicitacaoDoc(SolicitacaoRedeSimEntity solicitacao) {
        List solicitacoes = this.repositorySolicitacaoDocRedeSim.getSolicitacoesDocumento(solicitacao);
        if (!this.possuiAlgumaSolicitacaoFinalizada(solicitacoes)) {
            for (SolicitacaoDocRedeSimEntity solicitacaoDocRedeSim : solicitacoes) {
                if (!Objects.nonNull(solicitacaoDocRedeSim)) continue;
                solicitacaoDocRedeSim.setFinalizado(SimNaoEnum.getSimShortText());
                this.repositorySolicitacaoDocRedeSim.saveOrUpdate(solicitacaoDocRedeSim);
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected boolean possuiAlgumaSolicitacaoFinalizada(List<SolicitacaoDocRedeSimEntity> solicitacoes) {
        if (EloListUtils.safeIsEmpty(solicitacoes).booleanValue()) {
            return Boolean.TRUE;
        }
        for (SolicitacaoDocRedeSimEntity solicitacaoDocRedeSimEntity : solicitacoes) {
            if (!SimNaoEnum.equalSim((String)solicitacaoDocRedeSimEntity.getFinalizado()).booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected List<SolicitacaoRedeSimEntity> getSolicitacaoAguardandoSolicitacaoDocumento() {
        FiltroConsultaRedeSim filtro = new FiltroConsultaRedeSim.FiltroConsultaRedeSimBuilder().build();
        ArrayList situacao = Lists.newArrayList();
        situacao.add(SituacaoConsultaPreviaRedeSimEnum.AGUARDANDO_SOLICITACAO.getSigla());
        filtro.setSituacao((List)situacao);
        filtro.setTipo("S");
        return this.repositoryConsultaRedeSim.carregarListaConsultaRedeSim(filtro);
    }
}

